/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.w3c.dom.Element;

public final class AddressingUtil {
    private AddressingUtil() {
    }

    public static AddressingInfo getAddressingInfo(Element serviceRefElem, Properties orchestraProperties) {
        String scheme = XmlUtil.attribute(serviceRefElem, "reference-scheme");
        Element endpointRef = XmlUtil.element(serviceRefElem, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference");
        if ((scheme == null || scheme.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing")) && endpointRef != null) {
            return AddressingUtil.getAddressing2004Info(endpointRef, orchestraProperties);
        }
        Element endpointRef2005 = XmlUtil.element(serviceRefElem, "http://www.w3.org/2005/08/addressing", "EndpointReference");
        if ((scheme == null || scheme.equals("http://www.w3.org/2005/08/addressing")) && endpointRef2005 != null) {
            return AddressingUtil.getAddressing2005Info(endpointRef2005, orchestraProperties);
        }
        throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.unsupportedReference);
    }

    private static AddressingInfo getAddressing2004Info(Element endpointRef, Properties orchestraProperties) {
        Element addressElt = XmlUtil.element(endpointRef, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
        String address = addressElt.getTextContent();
        QName serviceQname = null;
        String portName = null;
        Element serviceNameElt = XmlUtil.element(endpointRef, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceName");
        if (serviceNameElt != null) {
            String serviceNameText = serviceNameElt.getTextContent();
            String[] splitted = serviceNameText.split(":", 2);
            if (splitted.length == 2) {
                String prefix = splitted[0];
                String namespace = serviceNameElt.lookupNamespaceURI(prefix);
                String localName = splitted[1];
                serviceQname = new QName(namespace, localName, prefix);
            } else {
                serviceQname = new QName(serviceNameElt.lookupNamespaceURI(null), serviceNameText);
            }
            portName = XmlUtil.attribute(serviceNameElt, "PortName");
        }
        Definition wsdlDefinition = null;
        return new AddressingInfo(address, wsdlDefinition, serviceQname, portName, orchestraProperties);
    }

    private static AddressingInfo getAddressing2005Info(Element endpointRef, Properties orchestraProperties) {
        Element addressElt = XmlUtil.element(endpointRef, "http://www.w3.org/2005/08/addressing", "Address");
        String address = addressElt.getTextContent();
        QName serviceQname = null;
        String portName = null;
        Definition wsdlDefinition = null;
        Element metadataElt = XmlUtil.element(endpointRef, "http://www.w3.org/2005/08/addressing", "metadata");
        if (metadataElt != null) {
            Element wsdlDefinitionElt;
            Element serviceNameElt = XmlUtil.element(endpointRef, "http://www.w3.org/2006/05/addressing/wsdl", "ServiceName");
            if (serviceNameElt != null) {
                String serviceNameText = serviceNameElt.getTextContent();
                String[] splitted = serviceNameText.split(":", 2);
                if (splitted.length == 2) {
                    String prefix = splitted[0];
                    String namespace = serviceNameElt.lookupNamespaceURI(prefix);
                    String localName = splitted[1];
                    serviceQname = new QName(namespace, localName, prefix);
                } else {
                    serviceQname = new QName(serviceNameElt.lookupNamespaceURI(null), serviceNameText);
                }
                portName = XmlUtil.attribute(serviceNameElt, "EndPointName");
            }
            if ((wsdlDefinitionElt = XmlUtil.element(endpointRef, "http://schemas.xmlsoap.org/wsdl/", "definitions")) != null) {
                wsdlDefinition = WsdlUtil.readWsdl(wsdlDefinitionElt);
            }
        }
        return new AddressingInfo(address, wsdlDefinition, serviceQname, portName, orchestraProperties);
    }

    private static String getOrchestraURLPrefix(Properties orchestraProperties) {
        return "http://" + orchestraProperties.getProperty("orchestra.servlet.host") + ":" + orchestraProperties.getProperty("orchestra.servlet.port") + "/" + orchestraProperties.getProperty("orchestra.servlet.path");
    }

    public static String replacePropertiesInOrchestraURL(String url, Properties orchestraProperties) {
        String url1 = url.replace("${orchestra.ws.url}", AddressingUtil.getOrchestraURLPrefix(orchestraProperties));
        String url2 = url1.replace("${HttpDefaultPort}", orchestraProperties.getProperty("orchestra.servlet.port"));
        String url3 = url2.replace("${orchestra.servlet.port}", orchestraProperties.getProperty("orchestra.servlet.port"));
        return url3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddressingInfo {
        private final String address;
        private final Definition wsdlDefinition;
        private final QName serviceQName;
        private final String portName;
        private Service service;
        private Port port;

        public AddressingInfo(String address, Definition wsdlDefinition, QName serviceQname, String portName, Properties orchestraProperties) {
            this.address = AddressingUtil.replacePropertiesInOrchestraURL(address, orchestraProperties);
            this.wsdlDefinition = wsdlDefinition;
            this.serviceQName = serviceQname;
            this.portName = portName;
            if (wsdlDefinition != null) {
                Map serviceMap = wsdlDefinition.getServices();
                this.resolveServiceAndPort(serviceMap.values());
            }
        }

        public String getAddress() {
            return this.address;
        }

        public Definition getWsdlDefinition() {
            return this.wsdlDefinition;
        }

        public QName getServiceQName() {
            return this.serviceQName;
        }

        public String getPortName() {
            return this.portName;
        }

        public Service getService() {
            return this.service;
        }

        public Port getPort() {
            return this.port;
        }

        public void resolveServiceAndPort(Collection<Service> knownServices) {
            for (Service candidateService : knownServices) {
                if (this.serviceQName != null && !this.serviceQName.equals(candidateService.getQName())) continue;
                if (this.portName != null) {
                    Port candidatePort = candidateService.getPort(this.portName);
                    if (candidatePort == null) continue;
                    this.service = candidateService;
                    this.port = candidatePort;
                    return;
                }
                Map servicePorts = candidateService.getPorts();
                for (Port candidatePort : servicePorts.values()) {
                    List elements = candidatePort.getExtensibilityElements();
                    if (elements.size() <= 0) continue;
                    for (ExtensibilityElement element : elements) {
                        if (!(element instanceof SOAPAddress) || !((SOAPAddress)element).getLocationURI().equals(this.address)) continue;
                        this.service = candidateService;
                        this.port = candidatePort;
                        return;
                    }
                }
            }
        }
    }
}

