/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.util.HashMap;
import java.util.Map;
import org.ow2.orchestra.axis.ProcessClassLoader;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

public final class ClassLoaderMap {
    private static Map<ProcessDefinitionUUID, ProcessClassLoader> classLoaders = new HashMap<ProcessDefinitionUUID, ProcessClassLoader>();

    private ClassLoaderMap() {
    }

    public static ProcessClassLoader getCL(ProcessDefinitionUUID processUUID) {
        if (classLoaders == null) {
            return null;
        }
        ProcessClassLoader result = classLoaders.get(processUUID);
        if (result == null) {
            throw new OrchestraRuntimeException("No process with UUID " + processUUID + " exists in ClassLoaderMap\n", null);
        }
        return result;
    }

    public static void addCL(ProcessDefinitionUUID processUUID, ProcessClassLoader cl) {
        classLoaders.put(processUUID, cl);
    }

    public static void removeCL(ProcessDefinitionUUID processUUID) {
        classLoaders.remove(processUUID);
    }
}

