/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.HibernateException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerFactory {
    private static final Logger log = LoggerFactory.getLogger((Class)OptimizerFactory.class);
    public static final String NONE = "none";
    public static final String HILO = "hilo";
    public static final String POOL = "pooled";
    private static Class[] CTOR_SIG = new Class[]{Class.class, Integer.TYPE};

    public static Optimizer buildOptimizer(String type, Class returnClass, int incrementSize) {
        String optimizerClassName = NONE.equals(type) ? NoopOptimizer.class.getName() : (HILO.equals(type) ? HiLoOptimizer.class.getName() : (POOL.equals(type) ? PooledOptimizer.class.getName() : type));
        try {
            Class optimizerClass = ReflectHelper.classForName(optimizerClassName);
            Constructor ctor = optimizerClass.getConstructor(CTOR_SIG);
            return (Optimizer)ctor.newInstance(returnClass, new Integer(incrementSize));
        }
        catch (Throwable ignore) {
            return new NoopOptimizer(returnClass, incrementSize);
        }
    }

    public static class PooledOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder hiValue;
        private IntegralDataTypeHolder value;

        public PooledOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
            if (incrementSize < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace("creating pooled optimizer with [incrementSize=" + incrementSize + "; returnClass=" + returnClass.getName() + "]");
            }
        }

        public synchronized Serializable generate(AccessCallback callback) {
            if (this.hiValue == null) {
                this.value = callback.getNextValue();
                if (this.value.lt(1L)) {
                    log.info("pooled optimizer source reported [" + this.value + "] as the initial value; use of 1 or greater highly recommended");
                }
                this.hiValue = callback.getNextValue();
            } else if (!this.hiValue.gt(this.value)) {
                this.hiValue = callback.getNextValue();
                this.value = this.hiValue.copy().subtract(this.incrementSize);
            }
            return this.value.makeValueThenIncrement();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.hiValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value.copy().decrement();
        }
    }

    public static class HiLoOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder upperLimit;
        private IntegralDataTypeHolder value;

        public HiLoOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
            if (incrementSize < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace("creating hilo optimizer with [incrementSize=" + incrementSize + "; returnClass=" + returnClass.getName() + "]");
            }
        }

        public synchronized Serializable generate(AccessCallback callback) {
            if (this.lastSourceValue == null) {
                this.lastSourceValue = callback.getNextValue();
                while (this.lastSourceValue.lt(1L)) {
                    this.lastSourceValue = callback.getNextValue();
                }
                this.upperLimit = this.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
                this.value = this.upperLimit.copy().subtract(this.incrementSize);
            } else if (!this.upperLimit.gt(this.value)) {
                this.lastSourceValue = callback.getNextValue();
                this.upperLimit = this.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
            }
            return this.value.makeValueThenIncrement();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value.copy().decrement();
        }

        public IntegralDataTypeHolder getHiValue() {
            return this.upperLimit;
        }
    }

    public static class NoopOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;

        public NoopOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
        }

        public Serializable generate(AccessCallback callback) {
            if (this.lastSourceValue == null) {
                do {
                    this.lastSourceValue = callback.getNextValue();
                } while (this.lastSourceValue.lt(1L));
            } else {
                this.lastSourceValue = callback.getNextValue();
            }
            return this.lastSourceValue.makeValue();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }
    }

    public static abstract class OptimizerSupport
    implements Optimizer {
        protected final Class returnClass;
        protected final int incrementSize;

        protected OptimizerSupport(Class returnClass, int incrementSize) {
            if (returnClass == null) {
                throw new HibernateException("return class is required");
            }
            this.returnClass = returnClass;
            this.incrementSize = incrementSize;
        }

        public final Class getReturnClass() {
            return this.returnClass;
        }

        public final int getIncrementSize() {
            return this.incrementSize;
        }
    }
}

