/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.full.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.runtime.CorrelationSetInitialization;
import org.ow2.orchestra.facade.runtime.impl.CorrelationSetInitializationImpl;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationSetInitializationFullImpl
implements CorrelationSetInitialization {
    private static final long serialVersionUID = 4978973329065042473L;
    protected long dbid;
    private ActivityInstanceUUID activityUUID;
    private Date date;
    private String name;
    protected Map<QName, Document> propertyValues;

    protected CorrelationSetInitializationFullImpl() {
    }

    public CorrelationSetInitializationFullImpl(CorrelationSetInitialization record) {
        this.activityUUID = record.getActivityUUID();
        this.date = new Date(record.getDate().getTime());
        this.name = record.getName();
        this.propertyValues = new HashMap<QName, Document>();
        for (Map.Entry<QName, Node> entry : record.getPropertyValues().entrySet()) {
            Element el = XmlUtil.getDocumentWithOneElement(new QName("http://orchestra.ow2.org", "ORCHESTRA_anonymous_element"));
            el.appendChild(el.getOwnerDocument().importNode(entry.getValue(), true));
            this.propertyValues.put(entry.getKey(), el.getOwnerDocument());
        }
    }

    public CorrelationSetInitializationFullImpl(ActivityInstanceUUID activityUUID, Date date, String name, Map<QName, Document> map) {
        this.activityUUID = activityUUID;
        this.date = new Date(date.getTime());
        this.name = name;
        this.propertyValues = new HashMap<QName, Document>();
        for (Map.Entry<QName, Document> entry : map.entrySet()) {
            this.propertyValues.put(entry.getKey(), XmlUtil.getDocumentFromString(XmlUtil.toString(entry.getValue())));
        }
    }

    @Override
    public ActivityInstanceUUID getActivityUUID() {
        return this.activityUUID;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<QName, Node> getPropertyValues() {
        HashMap<QName, Node> res = new HashMap<QName, Node>();
        for (Map.Entry<QName, Document> prop : this.propertyValues.entrySet()) {
            Document doc = prop.getValue();
            if (doc == null) continue;
            Element elt = doc.getDocumentElement();
            Element child = XmlUtil.element(elt);
            if (child != null) {
                res.put(prop.getKey(), child);
                continue;
            }
            res.put(prop.getKey(), elt.getFirstChild());
        }
        return res;
    }

    @Override
    public CorrelationSetInitialization copy() {
        return new CorrelationSetInitializationImpl(this);
    }
}

