/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ow2.orchestra.lang.evaluator.EvaluatorFactory;
import org.ow2.orchestra.util.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Snippet
implements Serializable {
    protected long dbid;
    protected String text;
    protected String language;
    protected Set<Namespace> namespaces;
    private static final long serialVersionUID = 1L;

    protected Snippet() {
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Set<Namespace> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Set<Namespace> namespaces) {
        this.namespaces = namespaces;
    }

    public void setNamespaces(Map<String, String> namespaceMap) {
        HashSet<Namespace> namespaces = new HashSet<Namespace>();
        for (Map.Entry<String, String> namespaceEntry : namespaceMap.entrySet()) {
            namespaces.add(new Namespace(namespaceEntry.getKey(), namespaceEntry.getValue()));
        }
        this.setNamespaces(namespaces);
    }

    protected EvaluatorFactory getEvaluatorFactory() {
        String myLanguage = this.getLanguage();
        if (myLanguage == null) {
            myLanguage = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";
        }
        EvaluatorFactory factory = EvaluatorFactory.getInstance(myLanguage);
        return factory;
    }

    public String toString() {
        return "Snippet, text = " + this.text;
    }
}

