/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.osgi;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.ow2.orchestra.env.BpelEnvironmentParser;
import org.ow2.orchestra.jmx.JMXAgent;
import org.ow2.orchestra.osgi.EnvironmentProviderService;
import org.ow2.orchestra.osgi.EnvironmentResourcesLoader;
import org.ow2.orchestra.osgi.OrchestraExtensionService;
import org.ow2.orchestra.osgi.impl.OrchestraExtensionClassLoader;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.env.PvmEnvironmentFactory;
import org.ow2.orchestra.services.itf.HttpPublisher;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestraOSGiEngine
implements Pojo {
    private InstanceManager __IM;
    public static final String ORCHESTRA_WAR_CONTEXT_PROP = "orchestra.war.context";
    public static final String ORCHESTRA_BUNDLE_CONTEXT_KEY = "orchestra.bundle.context";
    private boolean __Faliases;
    private final Map<String, Servlet> aliases;
    private boolean __FhttpService;
    private HttpService httpService;
    private boolean __ForchestraExtensionServices;
    private final List<OrchestraExtensionService> orchestraExtensionServices;
    private boolean __FenvironmentProviderService;
    private EnvironmentProviderService environmentProviderService;
    private boolean __FenvironmentDependencies;
    private Set<String> environmentDependencies;
    private boolean __FjmxAgent;
    private JMXAgent jmxAgent;
    private boolean __FenvironmentFactory;
    private EnvironmentFactory environmentFactory;
    private boolean __FbundleClassLoader;
    private final ClassLoader bundleClassLoader;
    private boolean __FbundleContext;
    private final BundleContext bundleContext;
    private boolean __FcanStart;
    private boolean canStart;
    private boolean __MsetEnvironmentProviderService$org_ow2_orchestra_osgi_EnvironmentProviderService;
    private boolean __MgetEnvironmentProviderService;
    private boolean __MgetHttpService;
    private boolean __MsetHttpService$org_osgi_service_http_HttpService;
    private boolean __MunsetHttpService$org_osgi_service_http_HttpService;
    private boolean __MunregisterServlets;
    private boolean __MsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService;
    private boolean __MunsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService;
    private boolean __Mstart;
    private boolean __McheckDependencies;
    private boolean __MstartOrchestra;
    private boolean __Mstop;

    Map __getaliases() {
        if (!this.__Faliases) {
            return this.aliases;
        }
        return (Map)this.__IM.onGet((Object)this, "aliases");
    }

    void __setaliases(Map map) {
        if (!this.__Faliases) {
            this.aliases = map;
            return;
        }
        this.__IM.onSet((Object)this, "aliases", (Object)map);
    }

    HttpService __gethttpService() {
        if (!this.__FhttpService) {
            return this.httpService;
        }
        return (HttpService)this.__IM.onGet((Object)this, "httpService");
    }

    void __sethttpService(HttpService httpService) {
        if (!this.__FhttpService) {
            this.httpService = httpService;
            return;
        }
        this.__IM.onSet((Object)this, "httpService", (Object)httpService);
    }

    List __getorchestraExtensionServices() {
        if (!this.__ForchestraExtensionServices) {
            return this.orchestraExtensionServices;
        }
        return (List)this.__IM.onGet((Object)this, "orchestraExtensionServices");
    }

    void __setorchestraExtensionServices(List list) {
        if (!this.__ForchestraExtensionServices) {
            this.orchestraExtensionServices = list;
            return;
        }
        this.__IM.onSet((Object)this, "orchestraExtensionServices", (Object)list);
    }

    EnvironmentProviderService __getenvironmentProviderService() {
        if (!this.__FenvironmentProviderService) {
            return this.environmentProviderService;
        }
        return (EnvironmentProviderService)this.__IM.onGet((Object)this, "environmentProviderService");
    }

    void __setenvironmentProviderService(EnvironmentProviderService environmentProviderService) {
        if (!this.__FenvironmentProviderService) {
            this.environmentProviderService = environmentProviderService;
            return;
        }
        this.__IM.onSet((Object)this, "environmentProviderService", (Object)environmentProviderService);
    }

    Set __getenvironmentDependencies() {
        if (!this.__FenvironmentDependencies) {
            return this.environmentDependencies;
        }
        return (Set)this.__IM.onGet((Object)this, "environmentDependencies");
    }

    void __setenvironmentDependencies(Set set) {
        if (!this.__FenvironmentDependencies) {
            this.environmentDependencies = set;
            return;
        }
        this.__IM.onSet((Object)this, "environmentDependencies", (Object)set);
    }

    JMXAgent __getjmxAgent() {
        if (!this.__FjmxAgent) {
            return this.jmxAgent;
        }
        return (JMXAgent)this.__IM.onGet((Object)this, "jmxAgent");
    }

    void __setjmxAgent(JMXAgent jMXAgent) {
        if (!this.__FjmxAgent) {
            this.jmxAgent = jMXAgent;
            return;
        }
        this.__IM.onSet((Object)this, "jmxAgent", (Object)jMXAgent);
    }

    EnvironmentFactory __getenvironmentFactory() {
        if (!this.__FenvironmentFactory) {
            return this.environmentFactory;
        }
        return (EnvironmentFactory)this.__IM.onGet((Object)this, "environmentFactory");
    }

    void __setenvironmentFactory(EnvironmentFactory environmentFactory) {
        if (!this.__FenvironmentFactory) {
            this.environmentFactory = environmentFactory;
            return;
        }
        this.__IM.onSet((Object)this, "environmentFactory", (Object)environmentFactory);
    }

    ClassLoader __getbundleClassLoader() {
        if (!this.__FbundleClassLoader) {
            return this.bundleClassLoader;
        }
        return (ClassLoader)this.__IM.onGet((Object)this, "bundleClassLoader");
    }

    void __setbundleClassLoader(ClassLoader classLoader) {
        if (!this.__FbundleClassLoader) {
            this.bundleClassLoader = classLoader;
            return;
        }
        this.__IM.onSet((Object)this, "bundleClassLoader", (Object)classLoader);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    boolean __getcanStart() {
        if (!this.__FcanStart) {
            return this.canStart;
        }
        Object object = this.__IM.onGet((Object)this, "canStart");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setcanStart(boolean bl) {
        if (!this.__FcanStart) {
            this.canStart = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "canStart", (Object)bl2);
    }

    public OrchestraOSGiEngine(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private OrchestraOSGiEngine(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__sethttpService(null);
        this.__setorchestraExtensionServices(new ArrayList());
        this.__setenvironmentDependencies(null);
        this.__setbundleClassLoader(new OrchestraExtensionClassLoader(this.__getorchestraExtensionServices()));
        this.__setcanStart(false);
        this.__setaliases(new HashMap());
        this.__setbundleContext(bundleContext);
    }

    public void setEnvironmentProviderService(EnvironmentProviderService environmentProviderService) {
        if (!this.__MsetEnvironmentProviderService$org_ow2_orchestra_osgi_EnvironmentProviderService) {
            this.__setEnvironmentProviderService(environmentProviderService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setEnvironmentProviderService$org_ow2_orchestra_osgi_EnvironmentProviderService", new Object[]{environmentProviderService});
            this.__setEnvironmentProviderService(environmentProviderService);
            this.__IM.onExit((Object)this, "setEnvironmentProviderService$org_ow2_orchestra_osgi_EnvironmentProviderService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setEnvironmentProviderService$org_ow2_orchestra_osgi_EnvironmentProviderService", throwable);
            throw throwable;
        }
    }

    private void __setEnvironmentProviderService(EnvironmentProviderService environmentProviderService) {
        this.__setenvironmentProviderService(environmentProviderService);
    }

    public EnvironmentProviderService getEnvironmentProviderService() {
        EnvironmentProviderService environmentProviderService;
        if (!this.__MgetEnvironmentProviderService) {
            return this.__getEnvironmentProviderService();
        }
        try {
            this.__IM.onEntry((Object)this, "getEnvironmentProviderService", new Object[0]);
            environmentProviderService = this.__getEnvironmentProviderService();
            this.__IM.onExit((Object)this, "getEnvironmentProviderService", (Object)environmentProviderService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getEnvironmentProviderService", throwable);
            throw throwable;
        }
        return environmentProviderService;
    }

    private EnvironmentProviderService __getEnvironmentProviderService() {
        return this.__getenvironmentProviderService();
    }

    public synchronized HttpService getHttpService() {
        HttpService httpService;
        if (!this.__MgetHttpService) {
            return this.__getHttpService();
        }
        try {
            this.__IM.onEntry((Object)this, "getHttpService", new Object[0]);
            httpService = this.__getHttpService();
            this.__IM.onExit((Object)this, "getHttpService", (Object)httpService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getHttpService", throwable);
            throw throwable;
        }
        return httpService;
    }

    private HttpService __getHttpService() {
        return this.__gethttpService();
    }

    public synchronized void setHttpService(HttpService httpService) {
        if (!this.__MsetHttpService$org_osgi_service_http_HttpService) {
            this.__setHttpService(httpService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setHttpService$org_osgi_service_http_HttpService", new Object[]{httpService});
            this.__setHttpService(httpService);
            this.__IM.onExit((Object)this, "setHttpService$org_osgi_service_http_HttpService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setHttpService$org_osgi_service_http_HttpService", throwable);
            throw throwable;
        }
    }

    private void __setHttpService(HttpService httpService) {
        this.__sethttpService(httpService);
    }

    public synchronized void unsetHttpService(HttpService httpService) {
        if (!this.__MunsetHttpService$org_osgi_service_http_HttpService) {
            this.__unsetHttpService(httpService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unsetHttpService$org_osgi_service_http_HttpService", new Object[]{httpService});
            this.__unsetHttpService(httpService);
            this.__IM.onExit((Object)this, "unsetHttpService$org_osgi_service_http_HttpService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unsetHttpService$org_osgi_service_http_HttpService", throwable);
            throw throwable;
        }
    }

    private void __unsetHttpService(HttpService httpService) {
        this.unregisterServlets();
        this.__sethttpService(null);
    }

    private void unregisterServlets() {
        if (!this.__MunregisterServlets) {
            this.__unregisterServlets();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterServlets", new Object[0]);
            this.__unregisterServlets();
            this.__IM.onExit((Object)this, "unregisterServlets", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterServlets", throwable);
            throw throwable;
        }
    }

    private void __unregisterServlets() {
        for (String alias : this.__getaliases().keySet()) {
            this.__gethttpService().unregister(alias);
            Misc.log(Level.INFO, "Alias unregistered: %s", alias);
        }
        this.__getaliases().clear();
    }

    public synchronized void setOrchestraExtensionService(OrchestraExtensionService orchestraExtensionService) throws Exception {
        if (!this.__MsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService) {
            this.__setOrchestraExtensionService(orchestraExtensionService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService", new Object[]{orchestraExtensionService});
            this.__setOrchestraExtensionService(orchestraExtensionService);
            this.__IM.onExit((Object)this, "setOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService", throwable);
            throw throwable;
        }
    }

    private void __setOrchestraExtensionService(OrchestraExtensionService orchestraExtensionService) throws Exception {
        this.__getorchestraExtensionServices().add(orchestraExtensionService);
        if (this.__getcanStart()) {
            try {
                this.startOrchestra();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public synchronized void unsetOrchestraExtensionService(OrchestraExtensionService orchestraExtensionService) throws Throwable {
        if (!this.__MunsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService) {
            this.__unsetOrchestraExtensionService(orchestraExtensionService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService", new Object[]{orchestraExtensionService});
            this.__unsetOrchestraExtensionService(orchestraExtensionService);
            this.__IM.onExit((Object)this, "unsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService", throwable);
            throw throwable;
        }
    }

    private void __unsetOrchestraExtensionService(OrchestraExtensionService orchestraExtensionService) throws Throwable {
        Set<String> missingDependencies;
        this.__getorchestraExtensionServices().remove(orchestraExtensionService);
        if (this.__getjmxAgent() != null && !(missingDependencies = this.checkDependencies()).isEmpty()) {
            Misc.log(Level.SEVERE, "Orchestra will be stopped because some environment dependencies are no longer available: " + Misc.deepToString(missingDependencies), new Object[0]);
            this.stop();
            this.__setcanStart(true);
        }
    }

    public synchronized void start() throws Exception {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() throws Exception {
        this.__setcanStart(true);
        Misc.log(Level.FINEST, "%s starting", this.getClass().getName());
        Misc.log(Level.INFO, "Environment will be taken from: %s", this.__getenvironmentProviderService().getEnvironmentURL());
        try {
            this.__setenvironmentDependencies(new HashSet());
            Document doc = XmlUtil.getDocumentFromURL(this.__getenvironmentProviderService().getEnvironmentURL());
            NodeList nl = doc.getElementsByTagName("*");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element n = (Element)nl.item(i);
                String className = XmlUtil.attribute(n, "class");
                if (className == null) continue;
                this.__getenvironmentDependencies().add(className);
            }
            this.startOrchestra();
        }
        catch (Exception t) {
            t.printStackTrace();
            throw t;
        }
    }

    private Set<String> checkDependencies() {
        Set<String> set;
        if (!this.__McheckDependencies) {
            return this.__checkDependencies();
        }
        try {
            this.__IM.onEntry((Object)this, "checkDependencies", new Object[0]);
            set = this.__checkDependencies();
            this.__IM.onExit((Object)this, "checkDependencies", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkDependencies", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __checkDependencies() {
        HashSet<String> missingDependencies = new HashSet<String>();
        for (String className : this.__getenvironmentDependencies()) {
            try {
                this.__getbundleClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                missingDependencies.add(className);
            }
        }
        return missingDependencies;
    }

    private synchronized void startOrchestra() throws ServletException, NamespaceException {
        if (!this.__MstartOrchestra) {
            this.__startOrchestra();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startOrchestra", new Object[0]);
            this.__startOrchestra();
            this.__IM.onExit((Object)this, "startOrchestra", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startOrchestra", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __startOrchestra() throws ServletException, NamespaceException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.__getbundleClassLoader());
        try {
            ClassLoader oldClassLoader;
            Set<String> missingDependencies = this.checkDependencies();
            if (!missingDependencies.isEmpty()) {
                Misc.log(Level.SEVERE, "Some environment dependencies are missing: " + Misc.deepToString(missingDependencies), new Object[0]);
                return;
            }
            ClassLoader newClassLoader = oldClassLoader = Thread.currentThread().getContextClassLoader();
            URL dirUrl = null;
            try {
                dirUrl = this.__getenvironmentProviderService().getEnvironmentURL().toURI().resolve("./").toURL();
            }
            catch (MalformedURLException e) {
                Misc.unreachableStatement();
            }
            catch (URISyntaxException e) {
                Misc.unreachableStatement();
            }
            if (dirUrl != null) {
                newClassLoader = AccessController.doPrivileged(new CreateEnvironmentClassLoaderAction(oldClassLoader, dirUrl, this.__getenvironmentProviderService().getEnvironmentBundle()));
            }
            Thread.currentThread().setContextClassLoader(newClassLoader);
            try {
                this.__setenvironmentFactory(BpelEnvironmentParser.parseEnvironmentFactoryFromURL(this.__getenvironmentProviderService().getEnvironmentURL()));
                ((PvmEnvironmentFactory)this.__getenvironmentFactory()).getEnvironmentFactoryCtxWireContext().setClassLoader(newClassLoader);
                ((PvmEnvironmentFactory)this.__getenvironmentFactory()).getEnvironmentCtxWireDefinition().setClassLoader(newClassLoader);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            this.__getenvironmentFactory().set(ORCHESTRA_BUNDLE_CONTEXT_KEY, this.__getbundleContext());
            Properties orchestraProperties = (Properties)this.__getenvironmentFactory().get("orchestra-properties");
            String servletPath = orchestraProperties.getProperty("orchestra.servlet.path");
            HttpContext context = this.__gethttpService().createDefaultHttpContext();
            Misc.log(Level.FINEST, "Context created: " + context, new Object[0]);
            HttpPublisher publisher = this.__getenvironmentFactory().get(HttpPublisher.class);
            Servlet servlet = publisher.getPublisherServlet(orchestraProperties);
            Misc.log(Level.FINEST, "Servlet created: %s", servlet);
            Hashtable initparams = new Hashtable();
            String inWar = this.__getbundleContext().getProperty(ORCHESTRA_WAR_CONTEXT_PROP);
            if (inWar != null && Boolean.TRUE.equals(XmlUtil.parseBooleanValue(inWar))) {
                this.__getaliases().put("/", servlet);
            } else {
                this.__getaliases().put("/" + servletPath, servlet);
            }
            for (Map.Entry mapping : this.__getaliases().entrySet()) {
                this.__gethttpService().registerServlet((String)mapping.getKey(), (Servlet)mapping.getValue(), initparams, context);
                Misc.log(Level.INFO, "Alias registered: %s for servlet: %s", mapping.getKey(), mapping.getValue());
            }
            this.__setjmxAgent(new JMXAgent());
            this.__getjmxAgent().startOrchestra(this.__getenvironmentFactory());
            this.__setcanStart(false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public synchronized void stop() throws Throwable {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() throws Throwable {
        this.__setcanStart(false);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.__getbundleClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.__getbundleClassLoader());
        }
        try {
            Misc.log(Level.FINEST, "%s stopping", this.getClass().getName());
            if (this.__gethttpService() != null) {
                this.unregisterServlets();
            }
            if (this.__getjmxAgent() != null) {
                this.__getjmxAgent().stopOrchestra();
                this.__setjmxAgent(null);
                this.__setenvironmentFactory(null);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("canStart")) {
                this.__FcanStart = true;
            }
            if (set.contains("environmentFactory")) {
                this.__FenvironmentFactory = true;
            }
            if (set.contains("environmentProviderService")) {
                this.__FenvironmentProviderService = true;
            }
            if (set.contains("environmentDependencies")) {
                this.__FenvironmentDependencies = true;
            }
            if (set.contains("orchestraExtensionServices")) {
                this.__ForchestraExtensionServices = true;
            }
            if (set.contains("bundleClassLoader")) {
                this.__FbundleClassLoader = true;
            }
            if (set.contains("aliases")) {
                this.__Faliases = true;
            }
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("httpService")) {
                this.__FhttpService = true;
            }
            if (set.contains("jmxAgent")) {
                this.__FjmxAgent = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setEnvironmentProviderService$org_ow2_orchestra_osgi_EnvironmentProviderService")) {
                this.__MsetEnvironmentProviderService$org_ow2_orchestra_osgi_EnvironmentProviderService = true;
            }
            if (set.contains("getEnvironmentProviderService")) {
                this.__MgetEnvironmentProviderService = true;
            }
            if (set.contains("getHttpService")) {
                this.__MgetHttpService = true;
            }
            if (set.contains("setHttpService$org_osgi_service_http_HttpService")) {
                this.__MsetHttpService$org_osgi_service_http_HttpService = true;
            }
            if (set.contains("unsetHttpService$org_osgi_service_http_HttpService")) {
                this.__MunsetHttpService$org_osgi_service_http_HttpService = true;
            }
            if (set.contains("unregisterServlets")) {
                this.__MunregisterServlets = true;
            }
            if (set.contains("setOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService")) {
                this.__MsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService = true;
            }
            if (set.contains("unsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService")) {
                this.__MunsetOrchestraExtensionService$org_ow2_orchestra_osgi_OrchestraExtensionService = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("checkDependencies")) {
                this.__McheckDependencies = true;
            }
            if (set.contains("startOrchestra")) {
                this.__MstartOrchestra = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CreateEnvironmentClassLoaderAction
    implements PrivilegedAction<EnvironmentResourcesLoader> {
        private final ClassLoader oldClassLoader;
        private final Bundle envBundle;
        private final URL dirUrl;

        private CreateEnvironmentClassLoaderAction(ClassLoader oldClassLoader, URL dirUrl, Bundle envBundle) {
            this.oldClassLoader = oldClassLoader;
            this.envBundle = envBundle;
            this.dirUrl = dirUrl;
        }

        @Override
        public EnvironmentResourcesLoader run() {
            return new EnvironmentResourcesLoader(this.dirUrl, this.envBundle, this.oldClassLoader);
        }
    }
}

