/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import java.util.Date;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.BpelFaultData;
import org.ow2.orchestra.facade.data.runtime.CorrelationSetInitializedData;
import org.ow2.orchestra.facade.data.runtime.ForeachInitializedData;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.data.runtime.ScopeStateUpdateData;
import org.ow2.orchestra.facade.data.runtime.TimerData;
import org.ow2.orchestra.facade.data.runtime.TransitionConditionUpdateData;
import org.ow2.orchestra.facade.data.runtime.VariableUpdateData;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ActivityWithChildrenFullInstance;
import org.ow2.orchestra.facade.runtime.full.ActivityWithSingleChildFullInstance;
import org.ow2.orchestra.facade.runtime.full.CompensationHandlerActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.FlowActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ForeachActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.PickActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.ScopeActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.TerminationHandlerActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.WaitActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.impl.ActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.AssignActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CatchActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CatchAllActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CompensateActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CompensateScopeActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CompensationHandlerActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CorrelationSetInitializationFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.EmptyActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ExitActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.FlowActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ForeachActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.IfActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.InvokeActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.PartnerLinkUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.PickActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessInstanceStateUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ReceiveActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.RepeatUntilActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ReplyActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.RethrowActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ScopeActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ScopeStateUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.SequenceActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.TerminationHandlerActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ThrowActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.TransitionConditionUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.UnknownActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.VariableUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.WaitActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.WaitingActivityFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.WhileActivityFullInstanceImpl;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.QuerierDbSession;
import org.ow2.orchestra.persistence.db.AbstractDbQuerier;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.util.Misc;

public class DbJournal
extends AbstractDbQuerier
implements Recorder {
    public DbJournal(QuerierDbSession dbSession) {
        super(dbSession);
    }

    public void recordInstanceStarted(ProcessInstanceData processInstanceData) {
        ProcessDefinitionUUID processUUID = processInstanceData.getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = processInstanceData.getUUID();
        Misc.checkArgsNotNull(processUUID, instanceUUID);
        ProcessFullInstanceImpl processFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID, processInstanceData.getDate());
        processFullInstance.addProcessInstanceState(new ProcessInstanceStateUpdateFullImpl(processInstanceData.getDate(), processInstanceData.getState()));
        this.addProcessInstance(processFullInstance);
        this.getQuerierDbSession().save(processFullInstance);
    }

    public void recordInstanceEnded(ProcessInstanceData processInstanceData) {
        ProcessInstanceUUID instanceUUID = processInstanceData.getUUID();
        Misc.checkArgsNotNull(instanceUUID);
        ProcessFullInstance processFullInstance = this.getProcessInstance(instanceUUID);
        processFullInstance.addProcessInstanceState(new ProcessInstanceStateUpdateFullImpl(processInstanceData.getDate(), processInstanceData.getState()));
        processFullInstance.end(processInstanceData.getState(), processInstanceData.getDate());
    }

    public void recordInstanceUpdated(ProcessInstanceData processInstanceData) {
        ProcessInstanceUUID instanceUUID = processInstanceData.getUUID();
        Misc.checkArgsNotNull(instanceUUID);
        ProcessFullInstance processFullInstance = this.getProcessInstance(instanceUUID);
        processFullInstance.addProcessInstanceState(new ProcessInstanceStateUpdateFullImpl(processInstanceData.getDate(), processInstanceData.getState()));
    }

    public void recordActivityStarted(ActivityInstanceData activityInstanceData) {
        ActivityFullInstanceImpl activityFullInstance;
        ProcessDefinitionUUID processUUID = activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = activityInstanceData.getProcessInstanceData().getUUID();
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = activityInstanceData.getActivityDefinitionData().getUUID();
        ActivityInstanceUUID encloserInstanceUUID = activityInstanceData.getEncloserUUID();
        Misc.checkArgsNotNull(processUUID, instanceUUID, activityUUID);
        Date startedDate = activityInstanceData.getDate();
        ActivityType activityType = activityInstanceData.getActivityDefinitionData().getType();
        switch (activityType) {
            case ASSIGN: {
                activityFullInstance = new AssignActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case CATCH_HANDLER: {
                activityFullInstance = new CatchActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case CATCHALL_HANDLER: {
                activityFullInstance = new CatchAllActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case TERMINATION_HANDLER: {
                activityFullInstance = new TerminationHandlerActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case COMPENSATION_HANDLER: {
                activityFullInstance = new CompensationHandlerActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case SCOPE: {
                activityFullInstance = new ScopeActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case PROCESS: {
                activityFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID, startedDate);
                break;
            }
            case SEQUENCE: {
                activityFullInstance = new SequenceActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case RECEIVE: {
                activityFullInstance = new ReceiveActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case REPLY: {
                activityFullInstance = new ReplyActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case INVOKE: {
                activityFullInstance = new InvokeActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case WAIT: {
                activityFullInstance = new WaitActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case PICK: {
                activityFullInstance = new PickActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case EMPTY: {
                activityFullInstance = new EmptyActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case EXIT: {
                activityFullInstance = new ExitActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case IF: {
                activityFullInstance = new IfActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case REPEAT_UNTIL: {
                activityFullInstance = new RepeatUntilActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case FOR_EACH: {
                activityFullInstance = new ForeachActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case WHILE: {
                activityFullInstance = new WhileActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case FLOW: {
                activityFullInstance = new FlowActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case COMPENSATE: {
                activityFullInstance = new CompensateActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case COMPENSATE_SCOPE: {
                activityFullInstance = new CompensateScopeActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case RETHROW: {
                activityFullInstance = new RethrowActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case THROW: {
                activityFullInstance = new ThrowActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            default: {
                activityFullInstance = new UnknownActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
            }
        }
        this.addActivityInstance(activityFullInstance);
        if (encloserInstanceUUID == null) {
            Misc.unreachableStatement("EncloserUUID cannot be null");
        } else if (encloserInstanceUUID.equals(activityFullInstance.getUUID())) {
            Misc.unreachableStatement("EncloserUUID (" + encloserInstanceUUID + ") cannot have the same UUID that the activityFullInstance (" + activityFullInstance.getUUID());
        } else {
            ActivityFullInstance encloserActivityFullInstance = this.getActivityInstance(encloserInstanceUUID);
            if (activityType.equals((Object)ActivityType.CATCH_HANDLER) || activityType.equals((Object)ActivityType.CATCHALL_HANDLER)) {
                ((ScopeActivityFullInstance)encloserActivityFullInstance).setFaultHandlerActivityInstance((ActivityWithSingleChildFullInstance)((Object)activityFullInstance));
            } else if (activityType.equals((Object)ActivityType.TERMINATION_HANDLER)) {
                ((ScopeActivityFullInstance)encloserActivityFullInstance).setTerminationHandlerActivityInstance((TerminationHandlerActivityFullInstance)((Object)activityFullInstance));
            } else if (activityType.equals((Object)ActivityType.COMPENSATION_HANDLER)) {
                ((ScopeActivityFullInstance)encloserActivityFullInstance).setCompensationHandlerActivityInstance((CompensationHandlerActivityFullInstance)((Object)activityFullInstance));
            } else if (encloserActivityFullInstance.isChildrenActivity()) {
                ((ActivityWithChildrenFullInstance)encloserActivityFullInstance).addEnclosedActivity(activityFullInstance);
            } else if (encloserActivityFullInstance.isSingleChildActivity()) {
                ((ActivityWithSingleChildFullInstance)encloserActivityFullInstance).setEnclosedActivity(activityFullInstance);
            } else {
                Misc.unreachableStatement("EncloserUUID (" + encloserInstanceUUID + ") has no possible enclosed activity. " + "It cannot be the parent of activityFullInstance (" + activityFullInstance.getUUID());
            }
        }
    }

    public void recordEventStarted(ActivityInstanceData activityInstanceData) {
        ProcessDefinitionUUID processUUID = activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = activityInstanceData.getProcessInstanceData().getUUID();
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = activityInstanceData.getActivityDefinitionData().getUUID();
        ActivityInstanceUUID encloserInstanceUUID = activityInstanceData.getEncloserUUID();
        Misc.checkArgsNotNull(processUUID, instanceUUID, activityUUID);
        ScopeActivityFullInstanceImpl activityFullInstance = new ScopeActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, activityInstanceData.getDate());
        this.addActivityInstance(activityFullInstance);
        if (encloserInstanceUUID == null) {
            Misc.unreachableStatement("EncloserUUID cannot be null");
        } else if (encloserInstanceUUID.equals(activityFullInstance.getUUID())) {
            Misc.unreachableStatement("EncloserUUID (" + encloserInstanceUUID + ") cannot have the same UUID that the activityFullInstance (" + activityFullInstance.getUUID());
        } else {
            ActivityFullInstance encloserActivityFullInstance = this.getActivityInstance(encloserInstanceUUID);
            ((ScopeActivityFullInstance)encloserActivityFullInstance).addEventInstance(activityFullInstance);
        }
    }

    public void recordExceptionOccured(BpelFaultData bpelFaultData) {
        ActivityFullInstance activityFullInstance = this.getActivityInstance(bpelFaultData.getActivityInstanceUUID());
        activityFullInstance.setLastException(bpelFaultData.getBpelFault().fullCopy());
    }

    public void recordActivityEnded(ActivityInstanceData activityInstanceData) {
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityFullInstance activityFullInstance = this.getActivityInstance(activityUUID);
        activityFullInstance.end(ActivityState.FINISHED, activityInstanceData.getDate());
    }

    public void recordActivityExited(ActivityInstanceData activityInstanceData) {
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityFullInstance activityFullInstance = this.getActivityInstance(activityUUID);
        activityFullInstance.end(ActivityState.EXITED, activityInstanceData.getDate());
    }

    public void recordActivityTerminated(ActivityInstanceData activityInstanceData) {
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityFullInstance activityFullInstance = this.getActivityInstance(activityUUID);
        activityFullInstance.end(ActivityState.TERMINATED, activityInstanceData.getDate());
    }

    public void recordTimerStarted(TimerData timerData) {
        ActivityFullInstance activityFullInstance = this.getActivityInstance(timerData.getActivityInstanceUUID());
        WaitingActivityFullImpl waitingActivity = new WaitingActivityFullImpl(timerData.getActivityDefinitionUUID(), timerData.getExpectedStartedDate());
        switch (activityFullInstance.getType()) {
            case PICK: {
                ((PickActivityFullInstance)activityFullInstance).addWaitingActivity(waitingActivity);
                break;
            }
            case WAIT: {
                WaitActivityFullInstance waitActivityFullInstance = (WaitActivityFullInstance)activityFullInstance;
                Misc.badStateIfNotNull(waitActivityFullInstance.getWaitingActivity(), "wait can only own one timer");
                waitActivityFullInstance.setWaitingActivity(waitingActivity);
                break;
            }
            case SCOPE: 
            case PROCESS: {
                break;
            }
            default: {
                Misc.unreachableStatement("Only wait and pick activity can own timers, not " + (Object)((Object)activityFullInstance.getType()));
            }
        }
    }

    public void recordForeachInitialized(ForeachInitializedData foreachInitializedData) {
        ForeachActivityFullInstance foreachActivityFullInstance = (ForeachActivityFullInstance)this.getActivityInstance(foreachInitializedData.getActivityInstanceUUID());
        foreachActivityFullInstance.update(foreachInitializedData.getStartValue(), foreachInitializedData.getStopValue(), foreachInitializedData.getCompletionConditionValue());
    }

    public void recordVariableUpdated(VariableUpdateData variableUpdateData) {
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)this.getActivityInstance(variableUpdateData.getScopeActivityUUID());
        VariableUpdateFullImpl varFullUpdate = new VariableUpdateFullImpl(scopeActivityFullInstance, variableUpdateData.getActivityUUID(), new Date(), variableUpdateData.getName(), variableUpdateData.getValue());
        scopeActivityFullInstance.getVariables().add(varFullUpdate);
        varFullUpdate.setIndex(scopeActivityFullInstance.getVariables().indexOf(varFullUpdate));
    }

    public void recordCorrelationSetInitialized(CorrelationSetInitializedData correlationSetInitializedData) {
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)this.getActivityInstance(correlationSetInitializedData.getScopeActivityUUID());
        scopeActivityFullInstance.getCorrelationSet().add(new CorrelationSetInitializationFullImpl(correlationSetInitializedData.getActivityUUID(), correlationSetInitializedData.getDate(), correlationSetInitializedData.getName(), correlationSetInitializedData.getPropertyValues()));
    }

    public void recordPartnerLinkUpdated(PartnerLinkUpdateData partnerLinkUpdateData) {
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)this.getActivityInstance(partnerLinkUpdateData.getScopeActivityUUID());
        if (scopeActivityFullInstance.getPartnerLink() == null) {
            Misc.unreachableStatement();
        }
        scopeActivityFullInstance.getPartnerLink().add(new PartnerLinkUpdateFullImpl(partnerLinkUpdateData.getActivityUUID(), partnerLinkUpdateData.getDate(), partnerLinkUpdateData.getName(), partnerLinkUpdateData.getPartnerLinkUpdateType(), partnerLinkUpdateData.getPartnerLinkReference()));
    }

    public void recordTransitionConditionUpdated(TransitionConditionUpdateData transitionConditionUpdateData) {
        FlowActivityFullInstance flowActivityFullInstance = (FlowActivityFullInstance)this.getActivityInstance(transitionConditionUpdateData.getFlowActivityUUID());
        flowActivityFullInstance.getTransitionConditionUpdateList().add(new TransitionConditionUpdateFullImpl(transitionConditionUpdateData.getStatus(), transitionConditionUpdateData.getName(), transitionConditionUpdateData.getDate()));
    }

    public void recordScopeStateChanged(ScopeStateUpdateData scopeStateUpdateData) {
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)this.getActivityInstance(scopeStateUpdateData.getScopeActivityUUID());
        scopeActivityFullInstance.getScopeState().add(new ScopeStateUpdateFullImpl(scopeStateUpdateData.getActivityUUID(), scopeStateUpdateData.getDate(), scopeStateUpdateData.getState()));
    }

    public void recordProcessDeployed(ProcessFullDefinition processFullDefinition) {
        this.getQuerierDbSession().save(processFullDefinition);
    }

    public void recordProcessUndeployed(ProcessDefinitionUUID processDefinitionUUID) {
        ProcessFullDefinition processFullDefinition = this.getProcessDefinition(processDefinitionUUID);
        processFullDefinition.setUndeployedDate(new Date());
    }
}

