/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db.hibernate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.type.BlobType;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;

public class SerializableToBlobType
extends BlobType {
    static final int[] SQL_TYPES = new int[]{2004};

    public int[] sqlTypes(Mapping mapping) {
        return SQL_TYPES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(ResultSet rs, String name, LobCreator lobCreator) throws SQLException {
        InputStream inStream = null;
        ObjectInputStream ois = null;
        try {
            Blob blob = rs.getBlob(name);
            if (blob == null) {
                Object var7_8 = null;
                return var7_8;
            }
            inStream = blob.getBinaryStream();
            if (inStream == null) {
                Object var7_9 = null;
                return var7_9;
            }
            ois = new ObjectInputStream(inStream);
            Object wsdlInfos = ois.readObject();
            ois.close();
            Object object = wsdlInfos;
            return object;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {}
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(PreparedStatement st, Object value, int index, SessionImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, SQL_TYPES[0]);
        } else {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream sr = new ObjectOutputStream(byteStream);
                try {
                    sr.writeObject(value);
                }
                finally {
                    sr.close();
                }
                if (session.getFactory().getDialect().useInputStreamToInsertBlob()) {
                    st.setBinaryStream(index, (InputStream)new ByteArrayInputStream(byteStream.toByteArray()), byteStream.size());
                } else {
                    Blob blob = Hibernate.getLobCreator(session).createBlob(byteStream.toByteArray());
                    st.setBlob(index, blob);
                }
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException(e);
            }
        }
    }
}

