/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.stream;

import java.io.InputStream;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.stream.StreamSource;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;

public class ResourceStreamSource
extends StreamSource {
    protected ClassLoader classLoader;
    protected String resource;

    public ResourceStreamSource(String resource) {
        this(resource, null);
    }

    public ResourceStreamSource(String resource, ClassLoader classLoader) {
        if (resource == null) {
            throw new PvmException("resource is null");
        }
        this.name = "resource://" + resource;
        this.resource = resource;
        this.classLoader = classLoader;
    }

    public InputStream openStream() {
        InputStream stream = ReflectUtil.getResourceAsStream(this.classLoader, this.resource);
        if (stream == null) {
            throw new PvmException("resource " + this.resource + " does not exist");
        }
        return stream;
    }
}

