/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.definition.activity.IScope;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.data.runtime.ScopeStateUpdateData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeRuntime {
    protected long dbid;
    private String uuid;
    protected IScope scopeDefinition = null;
    protected List<ScopeRuntime> endedChildren = new ArrayList<ScopeRuntime>();
    protected Map<String, VariableRuntime> variables = null;
    protected Map<String, PartnerLinkRuntime> partnerLinks = null;
    protected Map<String, CorrelationSetRuntime> correlationSets = null;
    protected ActivityInstanceUUID activityInstanceUUID;
    protected ScopeState state = ScopeState.INITIALIZATION_ERROR;
    protected BpelFaultException lastException = null;
    protected BpelExecution compensateExecution;

    protected ScopeRuntime() {
    }

    public ScopeRuntime(Scope scopeDefinition, BpelExecution execution, String uuid) {
        this.activityInstanceUUID = execution.getActivityInstanceUUID();
        this.uuid = uuid;
        this.scopeDefinition = scopeDefinition;
        this.createVariables(execution);
        this.createPartnerLinks(execution);
        this.createCorrelationSets(execution);
        this.state = ScopeState.INITIALIZED;
    }

    void addEndedChild(ScopeRuntime scopeRuntime) {
        this.getEndedChildren().add(scopeRuntime);
    }

    private void createVariables(BpelExecution execution) {
        this.variables = new HashMap<String, VariableRuntime>();
        Map<String, Variable> scopeVariables = this.scopeDefinition.getVariables();
        if (scopeVariables != null) {
            for (Variable variable : scopeVariables.values()) {
                this.variables.put(variable.getName(), new VariableRuntime(variable, execution, this));
            }
        }
    }

    public Collection<String> getVariableNames() {
        if (this.variables == null) {
            return Collections.emptySet();
        }
        return this.variables.keySet();
    }

    public VariableRuntime createVariable(BpelExecution execution, Variable variable) {
        VariableRuntime variableRuntime = new VariableRuntime(variable, execution, this);
        this.variables.put(variable.getName(), variableRuntime);
        return variableRuntime;
    }

    public void removeVariable(BpelExecution execution, Variable variable) {
        this.variables.remove(variable.getName());
    }

    private void createPartnerLinks(BpelExecution execution) {
        this.partnerLinks = new HashMap<String, PartnerLinkRuntime>();
        Map<String, PartnerLink> scopePartnerLinks = this.scopeDefinition.getPartnerLinks();
        if (scopePartnerLinks != null) {
            for (PartnerLink partnerLink : scopePartnerLinks.values()) {
                PartnerLinkRuntime partnerLinkRuntime = new PartnerLinkRuntime(partnerLink, execution, execution.getActivityInstanceUUID());
                this.partnerLinks.put(partnerLink.getName(), partnerLinkRuntime);
            }
        }
    }

    private void createCorrelationSets(BpelExecution execution) {
        this.correlationSets = new HashMap<String, CorrelationSetRuntime>();
        Map<String, CorrelationSet> correlationSetsMap = this.scopeDefinition.getCorrelationSets();
        if (correlationSetsMap != null) {
            for (CorrelationSet correlationSet : correlationSetsMap.values()) {
                CorrelationSetRuntime correlationSetRuntime = new CorrelationSetRuntime(correlationSet, execution.getActivityInstanceUUID());
                this.correlationSets.put(correlationSet.getName(), correlationSetRuntime);
            }
        }
    }

    public IScope getScopeDefinition() {
        return this.scopeDefinition;
    }

    public void setScopeDefinition(Scope scopeDefinition) {
        this.scopeDefinition = scopeDefinition;
    }

    public PartnerLinkRuntime getPartnerLink(String partnerLinkName) {
        return this.partnerLinks.get(partnerLinkName);
    }

    public boolean containsCorrelationSet(String csName) {
        return this.correlationSets.get(csName) != null;
    }

    public CorrelationSetRuntime getCorrelationSet(String csName) {
        return this.correlationSets.get(csName);
    }

    public VariableRuntime getVariable(String variableName) {
        return this.variables.get(variableName);
    }

    public boolean containsVariable(String variableName) {
        return this.variables.keySet().contains(variableName);
    }

    public String getUuid() {
        return this.uuid;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeRuntime)) {
            return false;
        }
        ScopeRuntime other = (ScopeRuntime)obj;
        return other.getUuid().equals(this.getUuid());
    }

    public List<ScopeRuntime> getEndedChildren() {
        return this.endedChildren;
    }

    public ScopeState getState() {
        return this.state;
    }

    public boolean isCompenseable() {
        return ScopeState.COMPLETED_SUCCESSFUL.equals((Object)this.state);
    }

    public void setState(ScopeState state) {
        this.state = state;
        EnvTool.getRecorder().recordScopeStateChanged(new ScopeStateUpdateData(this.activityInstanceUUID, this.activityInstanceUUID, state));
    }

    public BpelFaultException getLastException() {
        return this.lastException;
    }

    public void setLastException(BpelFaultException lastException) {
        this.lastException = lastException;
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        return this.activityInstanceUUID;
    }

    public BpelExecution getCompensateExecution() {
        return this.compensateExecution;
    }

    public void setCompensateExecution(BpelExecution compensateExecution) {
        this.compensateExecution = compensateExecution;
    }
}

