/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.Collection;
import java.util.Map;
import javax.wsdl.Part;
import javax.xml.soap.SOAPMessage;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelSOAPUtil {
    public static SOAPMessage buildRpcSOAPMessage(String soapAction, MessageVariable message, String operationName) {
        Document document = BpelSOAPUtil.buildRpcDocument(message, operationName);
        return SOAPUtil.buildSOAPMessage(document, soapAction);
    }

    public static Document buildRpcDocument(MessageVariable message, String operationName) {
        Document document = null;
        try {
            document = XmlUtil.getNewDocument();
            Element operation = document.createElement(operationName);
            for (Map.Entry<String, Element> entry : message.getParts().entrySet()) {
                String partName = entry.getKey();
                Element partElement = entry.getValue();
                if (BpelXmlUtil.isDefaultElement(partElement)) {
                    Element partEl = document.createElement(partName);
                    partEl.setTextContent(partElement.getTextContent());
                    operation.appendChild(partEl);
                    continue;
                }
                Node importedPart = document.importNode(partElement, true);
                operation.appendChild(importedPart);
            }
            document.appendChild(operation);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while building Rpc SOAP Message", e);
        }
        return document;
    }

    public static SOAPMessage buildDocumentSOAPMessage(String soapAction, MessageVariable message) {
        Element part = message.getParts().values().iterator().next();
        return SOAPUtil.buildDocumentSOAPMessage(soapAction, part);
    }

    public static MessageVariable buildMessageFromRpcSOAPBodyElement(Collection<Part> parts, Element soapBodyElement) {
        Document messageDoc = XmlUtil.getNewDocument();
        messageDoc.appendChild(messageDoc.createElement("message"));
        for (Part part : parts) {
            Element partElt = messageDoc.createElement(part.getName());
            messageDoc.getDocumentElement().appendChild(partElt);
            Element el = BpelUtil.getPartElement(soapBodyElement, part);
            if (el == null) {
                throw new OrchestraRuntimeException("Impossible to build a Message from the given rpc soap body element. One element with a localName equals to " + part.getName() + " is mandatory.");
            }
            if (part.getTypeName() != null && BpelUtil.isXmlSchemaNs(part.getTypeName().getNamespaceURI())) {
                String text = null;
                Node child = el.getFirstChild();
                text = child != null ? ((Text)child).getData() : el.getTextContent();
                Element elt = BpelXmlUtil.createDefaultElement(messageDoc);
                elt.setTextContent(text);
                partElt.appendChild(elt);
                continue;
            }
            Node node = messageDoc.importNode(el, true);
            partElt.appendChild(node);
        }
        return new MessageVariable(messageDoc);
    }

    public static MessageVariable buildMessageFromDocumentSOAPBodyElement(Collection<Part> parts, Element soapBodyElement) {
        Document messageDoc = XmlUtil.getNewDocument();
        messageDoc.appendChild(messageDoc.createElement("message"));
        Part part = parts.iterator().next();
        String partName = part.getName();
        Element partElt = messageDoc.createElement(partName);
        messageDoc.getDocumentElement().appendChild(partElt);
        partElt.appendChild(messageDoc.importNode(soapBodyElement, true));
        return new MessageVariable(messageDoc);
    }
}

