/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.facade.data.runtime.ForeachInitializedData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ForEachRuntime;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEach
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    private String counterName;
    private boolean parallel;
    private Expression startCounterValue;
    private Expression finalCounterValue;
    private Expression completionCondition;
    private boolean successfulBranchesOnly = false;

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            boolean isSuccessful = execution.getVariable("scopeState").equals((Object)ScopeState.COMPLETED_SUCCESSFUL);
            execution.removeVariable("scopeState");
            execution.end("ended");
            BpelExecution foreachExecution = execution.getParent();
            foreachExecution.removeExecution(execution);
            ForEachRuntime forEachRuntime = foreachExecution.getForEachRuntime();
            forEachRuntime.addTerminatedBranch(isSuccessful);
            if (!forEachRuntime.isCompleted()) {
                if (!this.parallel ? !this.sequentialFor(foreachExecution, forEachRuntime) : foreachExecution.isActive()) {
                    throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.completionConditionFailure);
                }
            } else {
                foreachExecution.terminate();
            }
        } else if (signal.equals("all-finished")) {
            this.afterRunned(execution);
        }
    }

    @Override
    public void executeActivity(BpelExecution execution) {
        int completionConditionRuntime;
        int finalCounterRuntimeValue;
        int startCounterRuntimeValue;
        try {
            startCounterRuntimeValue = this.startCounterValue.getEvaluator().evaluateUnsignedInt(execution);
        }
        catch (Exception e) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidExpressionValue, "startCounterValue : " + this.startCounterValue, e);
        }
        try {
            finalCounterRuntimeValue = this.finalCounterValue.getEvaluator().evaluateUnsignedInt(execution);
        }
        catch (Exception e) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidExpressionValue, "finalCounterValue : " + this.finalCounterValue, e);
        }
        int n = Math.max(0, finalCounterRuntimeValue - startCounterRuntimeValue + 1);
        Integer completionConditionValue = null;
        if (this.completionCondition != null) {
            try {
                completionConditionRuntime = this.completionCondition.getEvaluator().evaluateUnsignedInt(execution);
            }
            catch (Exception e) {
                throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidExpressionValue, "completionCondition : " + this.completionCondition, e);
            }
            if (completionConditionRuntime > n) {
                throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidBranchCondition);
            }
            completionConditionValue = completionConditionRuntime;
        } else {
            completionConditionRuntime = n;
        }
        ForEachRuntime forEachRuntime = new ForEachRuntime(startCounterRuntimeValue, finalCounterRuntimeValue, completionConditionRuntime, this.successfulBranchesOnly);
        EnvTool.getRecorder().recordForeachInitialized(new ForeachInitializedData(execution.getActivityInstanceUUID(), startCounterRuntimeValue, finalCounterRuntimeValue, completionConditionValue));
        execution.pushForEachRuntime(forEachRuntime);
        execution.waitForSignal();
        if (completionConditionRuntime != 0) {
            if (this.parallel) {
                this.parallelFor(execution, forEachRuntime);
            } else if (!this.sequentialFor(execution, forEachRuntime)) {
                Misc.unreachableStatement();
            }
        } else {
            execution.signal("all-finished");
        }
    }

    private BpelExecution createChildExecution(BpelExecution execution, int counterValue) {
        HashMap<String, Integer> additionnalVariables = new HashMap<String, Integer>();
        additionnalVariables.put(this.counterName, counterValue);
        BpelExecution childExecution = (BpelExecution)execution.createExecution();
        childExecution.createVariable("additionnalScopeVariables", additionnalVariables);
        return childExecution;
    }

    private boolean sequentialFor(BpelExecution execution, ForEachRuntime forEachRuntime) {
        NodeImpl node = execution.getNode();
        int counterValue = forEachRuntime.getNextCurrentCounterValue();
        if (counterValue != -1) {
            Node scope = node.getNodes().get(0);
            this.createChildExecution(execution, counterValue).execute(scope);
            return true;
        }
        return false;
    }

    private void parallelFor(BpelExecution execution, ForEachRuntime forEachRuntime) {
        NodeImpl node = execution.getNode();
        Node scope = node.getNodes().get(0);
        ArrayList<BpelExecution> childBpelExecutions = new ArrayList<BpelExecution>();
        int counterValue = forEachRuntime.getNextCurrentCounterValue();
        while (counterValue != -1) {
            childBpelExecutions.add(this.createChildExecution(execution, counterValue));
            counterValue = forEachRuntime.getNextCurrentCounterValue();
        }
        for (BpelExecution childBpelExecution : childBpelExecutions) {
            if (!execution.getExecutions().contains(childBpelExecution)) continue;
            childBpelExecution.execute(scope);
        }
    }

    public String getCounterName() {
        return this.counterName;
    }

    public void setCounterName(String counterName) {
        this.counterName = counterName;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public Expression getStartCounterValue() {
        return this.startCounterValue;
    }

    public void setStartCounterValue(Expression startCounterValue) {
        this.startCounterValue = startCounterValue;
    }

    public Expression getFinalCounterValue() {
        return this.finalCounterValue;
    }

    public void setFinalCounterValue(Expression finalCounterValue) {
        this.finalCounterValue = finalCounterValue;
    }

    public Expression getCompletionCondition() {
        return this.completionCondition;
    }

    public void setCompletionCondition(Expression completionCondition) {
        this.completionCondition = completionCondition;
    }

    public boolean isSuccessfulBranchesOnly() {
        return this.successfulBranchesOnly;
    }

    public void setSuccessfulBranchesOnly(boolean successfulBranchesOnly) {
        this.successfulBranchesOnly = successfulBranchesOnly;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.FOR_EACH;
    }
}

