/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.Misc;

public class OnAlarm {
    private static Logger log = Logger.getLogger(OnAlarm.class.getName());
    private final String uuid = Misc.getUniqueId("onAlarm");
    private Expression durationExpression;
    private Expression deadlineExpression;
    private Expression repeatEveryExpression;
    protected NodeImpl activity;

    public void setDurationExpression(Expression durationExpression) {
        this.durationExpression = durationExpression;
    }

    public void setDeadlineExpression(Expression deadlineExpression) {
        this.deadlineExpression = deadlineExpression;
    }

    public void setRepeatEveryExpression(Expression expression) {
        this.repeatEveryExpression = expression;
    }

    public NodeImpl getActivity() {
        return this.activity;
    }

    public void setActivity(NodeImpl activity) {
        this.activity = activity;
    }

    public Expression getDurationExpression() {
        return this.durationExpression;
    }

    public Expression getDeadlineExpression() {
        return this.deadlineExpression;
    }

    public Expression getRepeatEveryExpression() {
        return this.repeatEveryExpression;
    }

    public static Date computeTimer(BpelExecution execution, Expression deadlineExpression, Expression durationExpression, Expression repeatEveryExpression) {
        Date date = null;
        if (deadlineExpression != null) {
            date = deadlineExpression.getEvaluator().evaluateDeadline(execution).toGregorianCalendar().getTime();
            if (log.isLoggable(Level.FINE)) {
                log.fine("waiting until " + date);
            }
        } else if (durationExpression != null) {
            Duration duration = durationExpression.getEvaluator().evaluateDuration(execution);
            date = new Date(execution.getStartedDate().getTime());
            duration.addTo(date);
            if (log.isLoggable(Level.FINE)) {
                log.fine("waiting for " + duration);
            }
        } else if (repeatEveryExpression != null) {
            Duration duration = repeatEveryExpression.getEvaluator().evaluateDuration(execution);
            date = new Date(execution.getStartedDate().getTime());
            duration.addTo(date);
            if (log.isLoggable(Level.FINE)) {
                log.fine("waiting for " + duration);
            }
        } else {
            throw new OrchestraRuntimeException("invalid timer definition");
        }
        return date;
    }

    public String getUuid() {
        return this.uuid;
    }
}

