/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.orchestra.env.binding.ChainerBinding;
import org.ow2.orchestra.env.binding.ImplementationBinding;
import org.ow2.orchestra.env.binding.InvokeExecutorBinding;
import org.ow2.orchestra.env.binding.JmxServerBinding;
import org.ow2.orchestra.env.binding.OrchestraHibernateSessionFactoryBinding;
import org.ow2.orchestra.env.binding.OrchestraRetryInterceptorBinding;
import org.ow2.orchestra.env.binding.QuerierDbSessionBinding;
import org.ow2.orchestra.env.binding.QuerierListAccessorBinding;
import org.ow2.orchestra.env.binding.RuntimeDbSessionBinding;
import org.ow2.orchestra.env.binding.StaticClusterDescriptionBinding;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.env.PvmEnvironmentFactory;
import org.ow2.orchestra.pvm.internal.env.PvmEnvironmentFactoryParser;
import org.ow2.orchestra.pvm.internal.wire.binding.HibernateSessionFactoryBinding;
import org.ow2.orchestra.pvm.internal.xml.Binding;
import org.ow2.orchestra.pvm.internal.xml.Bindings;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.util.Misc;
import org.xml.sax.InputSource;

public class BpelEnvironmentParser
extends PvmEnvironmentFactoryParser {
    private static final String ENVIRONMENT_ORCHESTRA_XSD = "environment-orchestra.xsd";
    public static final String CLASSPATH_URL = "classpath://";

    public BpelEnvironmentParser() {
        Bindings bindings = this.getEnvironmentXmlParser().getBindings();
        this.getEnvironmentFactoryXmlParser().setBindings(bindings);
        bindings.addBinding(new RuntimeDbSessionBinding());
        bindings.addBinding(new QuerierDbSessionBinding());
        bindings.addBinding(new ImplementationBinding("repository"));
        bindings.addBinding(new ImplementationBinding("invoker"));
        bindings.addBinding(new ImplementationBinding("publisher"));
        bindings.addBinding(new ImplementationBinding("recorder"));
        bindings.addBinding(new ImplementationBinding("journal"));
        bindings.addBinding(new ImplementationBinding("finished-instance-handler"));
        bindings.addBinding(new ImplementationBinding("undeployed-process-handler"));
        bindings.addBinding(new ChainerBinding());
        bindings.addBinding(new ImplementationBinding("history"));
        bindings.addBinding(new ImplementationBinding("archiver"));
        bindings.addBinding(new ImplementationBinding("dead-job-handler"));
        bindings.addBinding(new QuerierListAccessorBinding());
        bindings.addBinding(new OrchestraRetryInterceptorBinding());
        bindings.addBinding(new JmxServerBinding());
        bindings.addBinding(new StaticClusterDescriptionBinding());
        bindings.addBinding(new ImplementationBinding("cluster"));
        bindings.addBinding(new InvokeExecutorBinding());
        Iterator<Binding> descriptorBindings = bindings.getBindings().get("descriptor").iterator();
        Binding binding = descriptorBindings.next();
        while (descriptorBindings.hasNext()) {
            if (binding instanceof HibernateSessionFactoryBinding) {
                descriptorBindings.remove();
            }
            binding = descriptorBindings.next();
        }
        bindings.addBinding(new OrchestraHibernateSessionFactoryBinding());
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public static BpelEnvironmentParser getInstance() {
        return new BpelEnvironmentParser();
    }

    public static EnvironmentFactory parseEnvironmentFactoryFromXmlString(String xmlString) {
        Parse parse = BpelEnvironmentParser.getInstance().createParse();
        EnvironmentFactory factory = (EnvironmentFactory)parse.setString(xmlString).execute().getDocumentObject();
        parse.checkProblems("environment");
        return factory;
    }

    public static synchronized EnvironmentFactory parseEnvironmentFactoryFromURL(URL url) {
        if (url == null) {
            throw new OrchestraRuntimeException("No environment xml found");
        }
        Parse parse = BpelEnvironmentParser.getInstance().createParse();
        PvmEnvironmentFactory factory = (PvmEnvironmentFactory)parse.setUrl(url).execute().getDocumentObject();
        parse.checkProblems("environment");
        return factory;
    }

    public static synchronized EnvironmentFactory parseEnvironmentFactoryFromResource(String resource) {
        Misc.checkArgsNotNull(resource);
        Parse parse = BpelEnvironmentParser.getInstance().createParse();
        EnvironmentFactory factory = (EnvironmentFactory)parse.setResource(resource).execute().getDocumentObject();
        parse.checkProblems("environment");
        return factory;
    }

    public synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        this.documentBuilderFactory = this.newDocumentBuilderFactory();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", "classpath://environment-orchestra.xsd");
        return this.documentBuilderFactory;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.startsWith(CLASSPATH_URL)) {
            String localpart = systemId.substring(CLASSPATH_URL.length());
            InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(localpart);
            if (inStream != null) {
                return new InputSource(inStream);
            }
        }
        return super.resolveEntity(publicId, systemId);
    }
}

