/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import java.util.Date;
import org.ow2.orchestra.facade.data.AbstractData;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.BpelFaultData;
import org.ow2.orchestra.facade.data.runtime.CorrelationSetInitializedData;
import org.ow2.orchestra.facade.data.runtime.ForeachInitializedData;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.data.runtime.ScopeStateUpdateData;
import org.ow2.orchestra.facade.data.runtime.TimerData;
import org.ow2.orchestra.facade.data.runtime.TransitionConditionUpdateData;
import org.ow2.orchestra.facade.data.runtime.VariableUpdateData;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.QuerierDbSession;
import org.ow2.orchestra.persistence.db.DbQuerier;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.util.EnvTool;

public class DbRecorder
extends DbQuerier
implements Recorder {
    public DbRecorder(QuerierDbSession dbSession) {
        super(dbSession);
    }

    private void storeRecord(Record record) {
        this.getQuerierDbSession().save(record);
    }

    public void recordActivityEnded(ActivityInstanceData activityInstanceData) {
        this.storeRecord(new Record(activityInstanceData.getProcessInstanceData().getProcessDefinitionData().getUUID(), activityInstanceData.getProcessInstanceData().getUUID(), activityInstanceData.getUUID(), activityInstanceData, RecordType.activityEnded));
    }

    public void recordActivityExited(ActivityInstanceData activityInstanceData) {
        this.storeRecord(new Record(activityInstanceData.getProcessInstanceData().getProcessDefinitionData().getUUID(), activityInstanceData.getProcessInstanceData().getUUID(), activityInstanceData.getUUID(), activityInstanceData, RecordType.activityExited));
    }

    public void recordActivityStarted(ActivityInstanceData activityInstanceData) {
        this.storeRecord(new Record(activityInstanceData.getProcessInstanceData().getProcessDefinitionData().getUUID(), activityInstanceData.getProcessInstanceData().getUUID(), activityInstanceData.getUUID(), activityInstanceData, RecordType.activityStarted));
    }

    public void recordActivityTerminated(ActivityInstanceData activityInstanceData) {
        this.storeRecord(new Record(activityInstanceData.getProcessInstanceData().getProcessDefinitionData().getUUID(), activityInstanceData.getProcessInstanceData().getUUID(), activityInstanceData.getUUID(), activityInstanceData, RecordType.activityTerminated));
    }

    public void recordCorrelationSetInitialized(CorrelationSetInitializedData correlationSetInitializedData) {
        this.storeRecord(new Record(null, null, correlationSetInitializedData.getScopeActivityUUID(), correlationSetInitializedData, RecordType.correlationSetInitialized));
    }

    public void recordEventStarted(ActivityInstanceData activityInstanceData) {
        this.storeRecord(new Record(activityInstanceData.getProcessInstanceData().getProcessDefinitionData().getUUID(), activityInstanceData.getProcessInstanceData().getUUID(), activityInstanceData.getUUID(), activityInstanceData, RecordType.eventStarted));
    }

    public void recordExceptionOccured(BpelFaultData bpelFaultData) {
        this.storeRecord(new Record(null, null, bpelFaultData.getActivityInstanceUUID(), bpelFaultData, RecordType.exceptionOccured));
    }

    public void recordForeachInitialized(ForeachInitializedData foreachInitializedData) {
        this.storeRecord(new Record(null, null, foreachInitializedData.getActivityInstanceUUID(), foreachInitializedData, RecordType.foreachInitialized));
    }

    public void recordInstanceEnded(ProcessInstanceData processInstanceData) {
        this.storeRecord(new Record(processInstanceData.getProcessDefinitionData().getUUID(), processInstanceData.getUUID(), processInstanceData.getUUID(), processInstanceData, RecordType.instanceEnded));
    }

    public void recordInstanceStarted(ProcessInstanceData processInstanceData) {
        this.storeRecord(new Record(processInstanceData.getProcessDefinitionData().getUUID(), processInstanceData.getUUID(), processInstanceData.getUUID(), processInstanceData, RecordType.instanceStarted));
    }

    public void recordInstanceUpdated(ProcessInstanceData processInstanceData) {
        this.storeRecord(new Record(processInstanceData.getProcessDefinitionData().getUUID(), processInstanceData.getUUID(), processInstanceData.getUUID(), processInstanceData, RecordType.instanceUpdated));
    }

    public void recordPartnerLinkUpdated(PartnerLinkUpdateData partnerLinkUpdateData) {
        this.storeRecord(new Record(null, null, partnerLinkUpdateData.getScopeActivityUUID(), partnerLinkUpdateData, RecordType.partnerLinkUpdated));
    }

    public void recordProcessDeployed(ProcessFullDefinition processFullDefinition) {
        this.getQuerierDbSession().save(processFullDefinition);
    }

    public void recordProcessUndeployed(ProcessDefinitionUUID processDefinitionUUID) {
        ProcessFullDefinition processFullDefinition = EnvTool.getJournalQueriers().getProcessDefinition(processDefinitionUUID);
        processFullDefinition.setUndeployedDate(new Date());
    }

    public void recordScopeStateChanged(ScopeStateUpdateData scopeStateUpdateData) {
        this.storeRecord(new Record(null, null, scopeStateUpdateData.getScopeActivityUUID(), scopeStateUpdateData, RecordType.scopeStateChanged));
    }

    public void recordTimerStarted(TimerData timerData) {
        this.storeRecord(new Record(null, null, timerData.getActivityInstanceUUID(), timerData, RecordType.timerStarted));
    }

    public void recordTransitionConditionUpdated(TransitionConditionUpdateData transitionConditionUpdateData) {
        this.storeRecord(new Record(null, null, transitionConditionUpdateData.getFlowActivityUUID(), transitionConditionUpdateData, RecordType.transitionConditionUpdated));
    }

    public void recordVariableUpdated(VariableUpdateData variableUpdateData) {
        this.storeRecord(new Record(null, null, variableUpdateData.getScopeActivityUUID(), variableUpdateData, RecordType.variableUpdated));
    }

    public static class Record {
        protected long dbid;
        protected ProcessDefinitionUUID processDefinitionUUID;
        protected ProcessInstanceUUID processInstanceUUID;
        protected ActivityInstanceUUID activityInstanceUUID;
        protected AbstractData data;
        protected RecordType type;

        protected Record() {
        }

        public Record(ProcessDefinitionUUID processDefinitionUUID, ProcessInstanceUUID processInstanceUUID, ActivityInstanceUUID activityInstanceUUID, AbstractData data, RecordType type) {
            this.processDefinitionUUID = processDefinitionUUID;
            this.processInstanceUUID = processInstanceUUID;
            this.activityInstanceUUID = activityInstanceUUID;
            this.data = data;
            this.type = type;
        }

        public ProcessInstanceUUID getProcessInstanceUUID() {
            return this.processInstanceUUID;
        }

        public ActivityInstanceUUID getActivityInstanceUUID() {
            return this.activityInstanceUUID;
        }

        public ProcessDefinitionUUID getProcessDefinitionUUID() {
            return this.processDefinitionUUID;
        }

        public RecordType getType() {
            return this.type;
        }

        public AbstractData getData() {
            return this.data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordType {
        activityEnded,
        activityExited,
        activityStarted,
        activityTerminated,
        correlationSetInitialized,
        eventStarted,
        exceptionOccured,
        foreachInitialized,
        instanceEnded,
        instanceStarted,
        instanceUpdated,
        partnerLinkUpdated,
        scopeStateChanged,
        timerStarted,
        transitionConditionUpdated,
        variableUpdated;

    }
}

