/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.hibernate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionType
implements UserType,
ParameterizedType {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(ExecutionType.class.getName());
    private final int[] sqlTypes = new int[]{12};
    protected String processResource;
    protected ProcessDefinitionImpl processDefinition;

    @Override
    public void setParameterValues(Properties properties) {
    }

    @Override
    public int[] sqlTypes() {
        return this.sqlTypes;
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        ExecutionImpl execution = this.createExecution(owner);
        String nodeName = rs.getString(names[0]);
        NodeImpl node = execution.getProcessDefinition().getNode(nodeName);
        execution.setNode(node);
        execution.setState("active");
        return execution;
    }

    private ExecutionImpl createExecution(Object owner) {
        ExecutionImpl execution = new ExecutionImpl();
        execution.setProcessDefinition(this.getProcessDefinition(owner));
        return execution;
    }

    private synchronized ProcessDefinitionImpl getProcessDefinition(Object owner) {
        if (this.processDefinition != null) {
            return this.processDefinition;
        }
        Class<?> ownerClass = owner.getClass();
        try {
            Method method = ownerClass.getMethod("getProcessDefinition", new Class[0]);
            this.processDefinition = (ProcessDefinitionImpl)method.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't get process definition for " + owner);
        }
        return this.processDefinition;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object owner, int index) throws SQLException {
        if (owner != null) {
            ExecutionImpl execution = (ExecutionImpl)owner;
            String nodeName = execution.getNode().getName();
            LOG.trace("binding 'execution-state{" + nodeName + "}' to parameter: " + index);
            st.setString(index, nodeName);
        }
    }

    @Override
    public Object deepCopy(Object object) {
        if (object == null) {
            return null;
        }
        ExecutionImpl original = (ExecutionImpl)object;
        NodeImpl node = new NodeImpl();
        node.setName(original.getNode().getName());
        ExecutionImpl copy = new ExecutionImpl();
        copy.setNode(node);
        return copy;
    }

    @Override
    public boolean equals(Object arg0, Object arg1) {
        if (arg0 == null || arg1 == null) {
            return false;
        }
        ExecutionImpl execution0 = (ExecutionImpl)arg0;
        ExecutionImpl execution1 = (ExecutionImpl)arg1;
        String nodeName0 = execution0.getNode().getName();
        String nodeName1 = execution1.getNode().getName();
        return nodeName0.equals(nodeName1);
    }

    @Override
    public int hashCode(Object object) {
        return object.hashCode();
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Class<?> returnedClass() {
        return Execution.class;
    }

    @Override
    public Object replace(Object arg0, Object arg1, Object arg2) {
        return null;
    }

    @Override
    public Object assemble(Serializable arg0, Object arg1) {
        return null;
    }

    @Override
    public Serializable disassemble(Object arg0) {
        return null;
    }
}

