/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.job.TimerImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.job.Timer;
import org.ow2.orchestra.pvm.session.TimerSession;

public class JobExecutorTimerSession
implements TimerSession {
    private static final Log LOG = Log.getLog(TimerSession.class.getName());
    private Transaction transaction;
    private JobExecutor jobExecutor;
    private JobDbSession jobDbSession;
    private boolean jobExecutorNotificationScheduled = false;
    private final int defaultRetries = 3;

    public void schedule(TimerImpl timer) {
        LOG.debug("scheduling " + timer);
        this.validate(timer);
        if (timer.isDefaultRetries()) {
            timer.setRetries(this.defaultRetries);
        }
        this.jobDbSession.save(timer);
        if (!this.jobExecutorNotificationScheduled) {
            this.jobExecutorNotificationScheduled = true;
            this.transaction.registerSynchronization(new JobAddedNotification(this.jobExecutor));
        }
    }

    protected void validate(Timer timer) {
        if (timer == null) {
            throw new PvmException("null timer scheduled");
        }
        if (timer.getExecution() == null) {
            throw new PvmException("timer has no execution specified");
        }
        if (timer.getSignalName() == null && timer.getEventName() == null) {
            throw new PvmException("timer has no signalName or eventName specified");
        }
        if (timer.getDueDate() == null) {
            throw new PvmException("timer scheduled at null date");
        }
        if (timer.getDueDate().getTime() < 0L) {
            throw new PvmException("timer scheduled with a negative date");
        }
    }

    public void cancel(TimerImpl timer) {
        LOG.debug("canceling " + timer);
        if (timer == null) {
            throw new PvmException("timer is null");
        }
        this.jobDbSession.delete(timer);
    }
}

