/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.pvm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.AcquireJobsCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.GetNextDueDateCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobHistoryEntry;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.DispatcherThread;
import org.ow2.orchestra.util.PrefixThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PvmJobExecutor
extends AbstractJobExecutor
implements JobExecutor {
    private int nbrOfThreads = 3;
    private int historySize = 200;
    private ThreadPoolExecutor threadPool;
    private DispatcherThread dispatcherThread = null;
    private LinkedBlockingQueue<Runnable> jobTasksQueue = null;
    private final List<JobHistoryEntry> history = new ArrayList<JobHistoryEntry>();

    @Override
    public synchronized void start() {
        if (this.commandService == null) {
            throw new PvmException("no command executor available in jobImpl executor");
        }
        if (!this.isActive) {
            this.acquireJobsCommand = new AcquireJobsCmd(this, this.getName(), this.getLockMillis());
            this.nextDueDateCommand = new GetNextDueDateCmd();
            this.jobTasksQueue = new LinkedBlockingQueue(2 * this.nbrOfThreads);
            this.isActive = true;
            AbstractJobExecutor.LOG.trace("starting jobImpl executor threads for jobImpl executor '" + this.name + "'...");
            this.threadPool = new ThreadPoolExecutor(this.nbrOfThreads, this.nbrOfThreads, 60L, TimeUnit.SECONDS, this.jobTasksQueue, new PrefixThreadFactory("JobExecutor"));
            try {
                Method m = ThreadPoolExecutor.class.getDeclaredMethod("allowCoreThreadTimeOut", Boolean.TYPE);
                m.invoke((Object)this.threadPool, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AbstractJobExecutor.LOG.trace("starting dispatcher thread for jobImpl executor '" + this.name + "'...");
            this.dispatcherThread = new DispatcherThread(this);
            this.dispatcherThread.start();
        } else {
            AbstractJobExecutor.LOG.trace("ignoring start: jobImpl executor '" + this.name + "' is already started'");
        }
    }

    @Override
    public synchronized void stop() {
        this.stop(false);
    }

    @Override
    public synchronized void stop(boolean join) {
        AbstractJobExecutor.LOG.debug("stopping jobImpl executor");
        if (this.isActive) {
            this.isActive = false;
            this.dispatcherThread.deactivate(true);
            this.waitTillQueueEmpty();
            this.threadPool.shutdown();
            if (join) {
                try {
                    this.threadPool.awaitTermination(180L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            AbstractJobExecutor.LOG.trace("ignoring stop: jobImpl executor '" + this.name + "' not started");
        }
    }

    protected void waitTillQueueEmpty() {
        while (!this.jobTasksQueue.isEmpty()) {
            AbstractJobExecutor.LOG.trace("waiting for jobImpl-id-queue to become empty");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                AbstractJobExecutor.LOG.trace("waiting for jobImpl-id-queue to become empty got interrupted");
            }
        }
    }

    protected BlockingQueue<Runnable> getJobTasksQueue() {
        return this.jobTasksQueue;
    }

    @Override
    protected int getAcquireJobSize() {
        return 1;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    @Override
    public DispatcherThread getDispatcherThread() {
        return this.dispatcherThread;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public List<JobHistoryEntry> getHistory() {
        return this.history;
    }

    public void setNbrOfJobExecutorThreads(int nbrOfJobExecutorThreads) {
        this.nbrOfThreads = nbrOfJobExecutorThreads;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historySize = historyMaxSize;
    }
}

