/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.svc;

import java.util.Random;
import org.hibernate.StaleStateException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.LockAcquisitionException;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.svc.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryInterceptor
extends Interceptor {
    private static final Log LOG = Log.getLog(RetryInterceptor.class.getName());
    private static final Random RANDOM = new Random();
    private int retries = 3;
    private long delay = 50L;
    private int delayFactor = 2;

    @Override
    public <T> T execute(Command<T> command) {
        int attempt = 1;
        long sleepTime = this.delay;
        long attemptFactor = this.delayFactor;
        while (attempt <= this.retries) {
            if (attempt > 1) {
                LOG.trace("retrying...");
            }
            try {
                return this.next.execute(command);
            }
            catch (RuntimeException e) {
                if (this.shouldRetry(command, e)) {
                    LOG.trace("command failed: " + e);
                    if (++attempt > this.retries) {
                        LOG.error("gave up after " + attempt + " attempts", e);
                        throw e;
                    }
                    LOG.trace("waiting " + sleepTime + " millis");
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e1) {
                        LOG.trace("retry sleeping got interrupted");
                    }
                    sleepTime = this.delay * (attemptFactor *= (long)(1 + RANDOM.nextInt(this.delayFactor - 1)));
                    continue;
                }
                throw e;
            }
        }
        throw new PvmException("gave up after " + attempt + " attempts");
    }

    protected boolean shouldRetry(Command<?> command, RuntimeException e) {
        return e instanceof StaleStateException || e instanceof LockAcquisitionException || e instanceof GenericJDBCException;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public int getDelayFactor() {
        return this.delayFactor;
    }

    public void setDelayFactor(int delayFactor) {
        this.delayFactor = delayFactor;
    }

    public static Random getRandom() {
        return RANDOM;
    }
}

