/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.UUID;
import javax.xml.namespace.QName;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.services.InvokeExecutor;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.var.MessageVariable;

public class ProcessInstanceMessageCarrier
implements MessageCarrier {
    private final long executionId;
    private final String uuid;

    public ProcessInstanceMessageCarrier(long executionId) {
        this.executionId = executionId;
        this.uuid = UUID.randomUUID().toString();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setFaultMessage(QName faultQName, MessageVariable messageToSend) {
        new InvokeExecutor.FinishInvokeCommand(this.executionId, new FaultWithMessageVariable(faultQName, messageToSend)).execute(Environment.getCurrent());
    }

    public void setMessage(MessageVariable messageToSend) {
        new InvokeExecutor.FinishInvokeCommand(this.executionId, messageToSend).execute(Environment.getCurrent());
    }

    public void throwMissingReply() {
        new InvokeExecutor.FinishInvokeCommand(this.executionId, new OrchestraRuntimeException("Process or scope is ended but no reply message available")).execute(Environment.getCurrent());
    }
}

