/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.handlers.impl;

import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.session.MessageSession;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.handlers.FinishedInstanceHandler;
import org.ow2.orchestra.util.ArchiveTool;
import org.ow2.orchestra.util.EnvTool;

public class AsyncArchiveFinishedInstanceHandler
implements FinishedInstanceHandler {
    public void handleFinishedInstance(ProcessInstanceUUID processInstanceUUID) {
        Environment.getFromCurrent(MessageSession.class).send(new ArchiveFinishedInstanceJob(processInstanceUUID));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArchiveFinishedInstanceJob
    extends MessageImpl<Void> {
        protected ProcessInstanceUUID processInstanceUUID;

        protected ArchiveFinishedInstanceJob() {
        }

        public ArchiveFinishedInstanceJob(ProcessInstanceUUID processInstanceUUID) {
            this.processInstanceUUID = processInstanceUUID;
        }

        @Override
        public Void execute(Environment environment) {
            Archiver archiver = EnvTool.getArchiver();
            Querier querier = EnvTool.getJournalQueriers();
            ArchiveTool.atomicArchive(this.processInstanceUUID, querier, archiver);
            JobDbSession jobDbSession = environment.get(JobDbSession.class);
            jobDbSession.delete(this);
            return null;
        }
    }
}

