/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.services.impl.QuerierChainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerierListAccessor {
    private final Querier allQueriers;
    private final Querier journals;
    private final Querier histories;

    public QuerierListAccessor(List<Querier> queriers) {
        ArrayList<Querier> journalsList = new ArrayList<Querier>();
        ArrayList<Querier> historiesList = new ArrayList<Querier>();
        for (Querier q : queriers) {
            if (q instanceof Recorder) {
                journalsList.add(q);
                continue;
            }
            if (q instanceof Archiver) {
                historiesList.add(q);
                continue;
            }
            throw new OrchestraRuntimeException("Invalid querier " + q + ": queriers should implement " + Recorder.class.getName() + " or " + Archiver.class.getName());
        }
        this.allQueriers = new QuerierChainer(queriers);
        this.journals = new QuerierChainer(journalsList);
        this.histories = new QuerierChainer(historiesList);
    }

    public Querier getAllQueriers() {
        return this.allQueriers;
    }

    public Querier getJournals() {
        return this.journals;
    }

    public Querier getHistories() {
        return this.histories;
    }
}

