/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.services.Querier;

public abstract class ArchiveTool {
    private ArchiveTool() {
    }

    public static void atomicArchive(ProcessDefinitionUUID uuid, Querier querier, Archiver archiver) {
        ProcessFullDefinition archivable = null;
        try {
            archivable = querier.removeProcessDefinition(uuid);
        }
        catch (Exception e) {
            throw new AtomicArchiveException("Can't remove process: " + uuid + " from querier: " + querier, e);
        }
        try {
            archiver.archive(archivable);
        }
        catch (Exception e) {
            throw new AtomicArchiveException("Can't archive archivable: " + archivable + " into archiver: " + archiver, e);
        }
    }

    public static void atomicArchive(ProcessInstanceUUID uuid, Querier querier, Archiver archiver) {
        ProcessFullInstance archivable = null;
        try {
            archivable = querier.removeProcessInstance(uuid);
        }
        catch (Exception e) {
            throw new AtomicArchiveException("Can't remove process: " + uuid + " from querier: " + querier, e);
        }
        try {
            archiver.archive(archivable);
        }
        catch (Exception e) {
            throw new AtomicArchiveException("Can't archive archivable: " + archivable + " into archiver: " + archiver, e);
        }
    }

    public static class AtomicArchiveException
    extends OrchestraRuntimeException {
        public AtomicArchiveException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

