/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.ws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.xml.Problem;
import org.ow2.orchestra.util.AddressingUtil;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSDeployer {
    private static Logger log = Logger.getLogger(WSDeployer.class.getName());
    public static final String URI_WSDL11_SOAP11 = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String URI_WSDL11_SOAP12 = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String DEFAULT_SOAP_BINDING_STYLE = "document";
    public static final String SOAP_HTTP_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/http";
    private final List<Problem> problems;
    protected ProcessDefinitionUUID processUUID;
    protected final Properties orchestraProperties;
    protected final String expectedAddressPrefix;

    protected WSDeployer(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
        this.problems = new ArrayList<Problem>();
        this.orchestraProperties = (Properties)Environment.getFromCurrent("orchestra-properties");
        this.expectedAddressPrefix = AddressingUtil.replacePropertiesInOrchestraURL("${orchestra.ws.url}/", this.orchestraProperties);
    }

    public void deploy(List<Service> services) {
        this.checkSupport(services);
        if (this.problems.size() > 0) {
            String problemsAsString = this.printProblems();
            log.severe(problemsAsString);
            throw new OrchestraRuntimeException(problemsAsString);
        }
        if (services.size() == 0) {
            throw new OrchestraRuntimeException("No service to deploy.");
        }
        this.checkWSEngineIsAvailable();
        this.deployServices(services);
    }

    public boolean undeploy(List<Service> services) {
        this.checkSupport(services);
        if (this.problems.size() != 0) {
            log.severe(this.printProblems());
            return false;
        }
        this.checkWSEngineIsAvailable();
        this.undeployServices(services);
        return true;
    }

    protected String printProblems() {
        StringBuffer buf = new StringBuffer();
        buf.append("Problems while deploying web services:").append(Misc.LINE_SEPARATOR);
        for (Problem problem : this.problems) {
            buf.append("- ").append(problem).append(Misc.LINE_SEPARATOR);
        }
        return buf.toString();
    }

    protected void addProblem(Binding binding, String mess, String severity) {
        if (mess != null) {
            this.addProblem("The following problem was found on binding : " + binding.getQName() + "\n" + mess, severity);
        }
    }

    protected void addProblem(Binding binding, BindingOperation bindingOperation, String mess, String severity) {
        if (mess != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The following problem was found on binding : " + binding.getQName());
            stringBuffer.append("\nThe problem was found in operation : " + bindingOperation.getName());
            stringBuffer.append("\n");
            stringBuffer.append(mess);
            this.addProblem(stringBuffer.toString(), severity);
        }
    }

    protected void addProblem(Binding binding, Operation operation, String mess, String severity) {
        if (mess != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The following problem was found on binding : " + binding.getQName());
            stringBuffer.append("\nThe problem was found in operation : " + operation.getName());
            stringBuffer.append("\n");
            stringBuffer.append(mess);
            this.addProblem(stringBuffer.toString(), severity);
        }
    }

    protected void addProblem(String mess, String severity) {
        this.problems.add(new Problem(mess, null, severity));
    }

    protected abstract void deployServices(List<Service> var1);

    protected abstract void undeployServices(List<Service> var1);

    protected abstract void checkWSEngineIsAvailable();

    protected abstract String checkOperationType(OperationType var1);

    protected abstract String checkSoapVersion(ExtensibilityElement var1);

    protected abstract String checkTransport(ExtensibilityElement var1);

    protected abstract String checkOperationStyle(String var1);

    protected abstract String checkUse(ExtensibilityElement var1);

    protected abstract String checkSoapBody(ExtensibilityElement var1);

    protected abstract String checkSoapFault(ExtensibilityElement var1);

    public List<Service> checkSupport(List<Service> services) {
        ArrayList<Service> soapServices = new ArrayList<Service>();
        for (Service service : services) {
            Collection ports = service.getPorts().values();
            for (Port port : ports) {
                String address = this.getAddressFromPort(port);
                if (address != null) {
                    if (!this.isAddressSupported(address)) {
                        this.addProblem("Port " + port.getName() + " of service " + service.getQName() + " specifies an unexpected SOAP address " + address + "." + Misc.LINE_SEPARATOR + " SOAP address must start with " + this.expectedAddressPrefix + "." + " Please check the wsdl file and orchestra settings.", "error");
                    }
                    soapServices.add(service);
                }
                Binding binding = port.getBinding();
                this.checkBinding(binding);
            }
        }
        return soapServices;
    }

    protected boolean isAddressSupported(String address) {
        return address.startsWith(this.expectedAddressPrefix);
    }

    protected void checkBinding(Binding binding) {
        ExtensibilityElement soapBinding = WSDeployer.getSoapBindingFromBinding(binding);
        if (soapBinding == null) {
            this.addProblem(binding, "this binding is not a soap binding.", "error");
        } else {
            String mess = this.checkSoapVersion(soapBinding);
            this.addProblem(binding, mess, "error");
            mess = this.checkTransport(soapBinding);
            this.addProblem(binding, mess, "error");
            String soapBindingStyle = WSDeployer.getSOAPStyle(soapBinding);
            if (soapBindingStyle == null) {
                soapBindingStyle = DEFAULT_SOAP_BINDING_STYLE;
            }
            List operations = binding.getBindingOperations();
            for (BindingOperation bindingOperation : operations) {
                this.checkOperation(binding, bindingOperation, soapBindingStyle);
            }
        }
    }

    protected void checkOperation(Binding binding, BindingOperation bindingOperation, String soapBindingStyle) {
        BindingOutput output;
        String operationStyle2;
        Operation operation = bindingOperation.getOperation();
        OperationType operationType = operation.getStyle();
        String mess = this.checkOperationType(operationType);
        this.addProblem(binding, operation, mess, "error");
        ExtensibilityElement soapOperation = WSDeployer.getSoapOperationFromBindingOperation(bindingOperation);
        String operationStyle = soapBindingStyle;
        if (soapOperation != null && (operationStyle2 = WSDeployer.getSOAPStyle(soapOperation)) != null) {
            operationStyle = operationStyle2;
        }
        if (operationStyle.equals(DEFAULT_SOAP_BINDING_STYLE)) {
            this.verifyThereIsOnlyOnePart(binding, operation);
        }
        mess = this.checkOperationStyle(operationStyle);
        this.addProblem(binding, bindingOperation, mess, "error");
        BindingInput input = bindingOperation.getBindingInput();
        if (input != null) {
            ExtensibilityElement soapBody = this.getSoapBodyFromElement((ElementExtensible)input);
            this.verifySoapBody(binding, bindingOperation, soapBody);
        }
        if ((output = bindingOperation.getBindingOutput()) != null) {
            ExtensibilityElement soapBody = this.getSoapBodyFromElement((ElementExtensible)output);
            this.verifySoapBody(binding, bindingOperation, soapBody);
        }
        Collection faults = bindingOperation.getBindingFaults().values();
        for (BindingFault fault : faults) {
            ExtensibilityElement soapBody = this.getSoapFaultFromElement((ElementExtensible)fault);
            this.verifySoapFault(binding, bindingOperation, soapBody);
        }
    }

    protected void verifySoapBody(Binding binding, BindingOperation bindingOperation, ExtensibilityElement soapBody) {
        if (soapBody != null) {
            String mess = this.checkUse(soapBody);
            this.addProblem(binding, bindingOperation, mess, "error");
            mess = this.checkSoapBody(soapBody);
            this.addProblem(binding, bindingOperation, mess, "error");
        } else {
            String mess = "There is a missing soapBody";
            this.addProblem(binding, bindingOperation, mess, "error");
        }
    }

    protected void verifySoapFault(Binding binding, BindingOperation bindingOperation, ExtensibilityElement soapFault) {
        if (soapFault != null) {
            String mess = this.checkUse(soapFault);
            this.addProblem(binding, bindingOperation, mess, "error");
            mess = this.checkSoapFault(soapFault);
            this.addProblem(binding, bindingOperation, mess, "error");
        } else {
            String mess = "There is a missing soapFault";
            this.addProblem(binding, bindingOperation, mess, "error");
        }
    }

    protected void verifyThereIsOnlyOnePart(Binding binding, Operation operation) {
        Output output;
        int nbOfParts;
        Input input = operation.getInput();
        if (input != null && (nbOfParts = input.getMessage().getParts().size()) > 1) {
            this.addProblem(binding, operation, "This operation is used in document style and is using an input message containing more than one part", "error");
        }
        if ((output = operation.getOutput()) != null && (nbOfParts = output.getMessage().getParts().size()) > 1) {
            this.addProblem(binding, operation, "This operation is used in document style and is using an output message containing more than one part", "error");
        }
        Collection faults = operation.getFaults().values();
        for (Fault fault : faults) {
            nbOfParts = fault.getMessage().getParts().size();
            if (nbOfParts <= 1) continue;
            this.addProblem(binding, operation, "This operation is used in document style and is using a fault message containing more than one part", "error");
        }
    }

    public static <T> T getFromList(List<?> list, Class<? extends T> ... types) {
        for (Object o : list) {
            for (Class<T> clazz : types) {
                if (!clazz.isAssignableFrom(o.getClass())) continue;
                return (T)o;
            }
        }
        return null;
    }

    protected String getAddressFromPort(Port p) {
        String endpoint = null;
        List extensibilityList = p.getExtensibilityElements();
        for (ExtensibilityElement obj : extensibilityList) {
            if (obj instanceof SOAPAddress) {
                endpoint = ((SOAPAddress)obj).getLocationURI();
                continue;
            }
            if (!(obj instanceof SOAP12Address)) continue;
            endpoint = ((SOAP12Address)obj).getLocationURI();
        }
        if (endpoint != null) {
            String url = AddressingUtil.replacePropertiesInOrchestraURL(endpoint, this.orchestraProperties);
            return url;
        }
        return null;
    }

    public static ExtensibilityElement getSoapBindingFromBinding(Binding binding) {
        return (ExtensibilityElement)WSDeployer.getFromList(binding.getExtensibilityElements(), SOAPBinding.class, SOAP12Binding.class);
    }

    public static ExtensibilityElement getSoapOperationFromBindingOperation(BindingOperation bindingOperation) {
        return (ExtensibilityElement)WSDeployer.getFromList(bindingOperation.getExtensibilityElements(), SOAPOperation.class, SOAP12Operation.class);
    }

    public static String getSOAPStyle(ExtensibilityElement element) {
        if (element instanceof SOAPBinding) {
            return ((SOAPBinding)element).getStyle();
        }
        if (element instanceof SOAP12Binding) {
            return ((SOAP12Binding)element).getStyle();
        }
        if (element instanceof SOAPOperation) {
            return ((SOAPOperation)element).getStyle();
        }
        if (element instanceof SOAP12Operation) {
            return ((SOAP12Operation)element).getStyle();
        }
        return null;
    }

    protected ExtensibilityElement getSoapBodyFromElement(ElementExtensible element) {
        return (ExtensibilityElement)WSDeployer.getFromList(element.getExtensibilityElements(), SOAPBody.class, SOAP12Body.class);
    }

    protected ExtensibilityElement getSoapFaultFromElement(ElementExtensible element) {
        return (ExtensibilityElement)WSDeployer.getFromList(element.getExtensibilityElements(), SOAPFault.class, SOAP12Fault.class);
    }

    public ProcessDefinitionUUID getProcessUUID() {
        return this.processUUID;
    }

    public void setProcessUUID(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }
}

