/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cluster;

import java.io.Serializable;
import org.ow2.orchestra.cluster.Server;
import org.ow2.orchestra.facade.AccessorUtil;
import org.ow2.orchestra.facade.ManagementAPI;
import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;

public class JmxServer
implements Server,
Serializable {
    private String jmxServiceUrl;
    private String jmxObjectName;

    public JmxServer(String jmxServiceUrl, String jmxObjectName) {
        this.jmxServiceUrl = jmxServiceUrl;
        this.jmxObjectName = jmxObjectName;
    }

    public JmxServer() {
    }

    public String getJmxObjectName() {
        return this.jmxObjectName;
    }

    public String getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    public ManagementAPI getManagementAPI() {
        try {
            return AccessorUtil.getManagementAPI(this.jmxServiceUrl, this.jmxObjectName);
        }
        catch (OrchestraException e) {
            throw new OrchestraRuntimeException(e);
        }
    }

    public String toString() {
        return "[Orchestra JMX node: serviceUrl=" + this.jmxServiceUrl + " objectName=" + this.jmxObjectName + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JmxServer)) {
            return false;
        }
        JmxServer other = (JmxServer)obj;
        return this.jmxServiceUrl.equals(other.jmxServiceUrl) && this.jmxObjectName.equals(other.jmxObjectName);
    }

    public int hashCode() {
        return this.jmxServiceUrl.hashCode() + this.jmxObjectName.hashCode();
    }
}

