/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.activity.BaseCatchActivity;
import org.ow2.orchestra.definition.activity.ICatchActivity;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.def.full.impl.CatchFullDefinitionImpl;
import org.ow2.orchestra.facade.exception.FaultWithElement;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.wsdl.WsdlsInfos;

public class CatchActivity
extends BaseCatchActivity
implements ICatchActivity {
    private static final long serialVersionUID = -245494906565371303L;
    protected QName faultQName;
    protected Variable catchVariableDefinition;

    protected CatchActivity() {
        super(null, null, null);
    }

    public CatchActivity(NodeImpl child, ActivityDefinitionUUID uuid, String name, CatchFullDefinitionImpl catchDefinition, WsdlsInfos wsdlsInfos) {
        super(child, uuid, name);
        this.faultQName = catchDefinition.getFaultName();
        if (catchDefinition.getFaultVariable() != null) {
            this.catchVariableDefinition = new Variable();
            this.catchVariableDefinition.setName(catchDefinition.getFaultVariable());
            if (catchDefinition.getFaultMessageType() != null) {
                this.catchVariableDefinition.setMessageType(catchDefinition.getFaultMessageType());
            } else if (catchDefinition.getFaultElement() != null) {
                this.catchVariableDefinition.setElement(catchDefinition.getFaultElement());
            } else {
                Misc.unreachableStatement("faultVariable is non null but both faultMessageType and faultElement are null");
            }
            this.catchVariableDefinition.initDefaultValue(wsdlsInfos);
        }
    }

    public ActivityType getType() {
        return ActivityType.CATCH_HANDLER;
    }

    public QName getFaultName() {
        return this.faultQName;
    }

    public void beforeRunning(BpelExecution bpelExecution) {
        super.beforeRunning(bpelExecution);
        if (this.catchVariableDefinition != null) {
            ScopeRuntime scopeRuntime = bpelExecution.getCurrentScopeRuntime();
            if (scopeRuntime.containsVariable(this.catchVariableDefinition.getName())) {
                Misc.unreachableStatement("The scope runtime " + scopeRuntime + " already contains a variable called " + this.catchVariableDefinition.getName());
            }
            VariableRuntime vr = scopeRuntime.createVariable(bpelExecution, this.catchVariableDefinition);
            if (this.catchVariableDefinition.getMessageType() != null) {
                FaultWithMessageVariable fault = (FaultWithMessageVariable)scopeRuntime.getLastException();
                vr.setValue(fault.getFaultMessage().duplicate());
            } else if (this.catchVariableDefinition.getElement() != null) {
                FaultWithElement fault = (FaultWithElement)scopeRuntime.getLastException();
                vr.setValue(fault.getFaultElement(), true);
            } else {
                Misc.unreachableStatement("catchVariableDefinition's messageType and element attributes are both null");
            }
            vr.updated(bpelExecution.getActivityInstanceUUID());
        }
    }

    public void signal(BpelExecution execution) {
        super.signal(execution);
        if (this.catchVariableDefinition != null) {
            ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
            scopeRuntime.removeVariable(execution, this.catchVariableDefinition);
        }
    }

    public QName getFaultMessageType() {
        if (this.catchVariableDefinition == null) {
            return null;
        }
        return this.catchVariableDefinition.getMessageType();
    }

    public QName getFaultElement() {
        if (this.catchVariableDefinition == null) {
            return null;
        }
        return this.catchVariableDefinition.getElement();
    }

    public String getFaultVariable() {
        if (this.catchVariableDefinition == null) {
            return null;
        }
        return this.catchVariableDefinition.getName();
    }
}

