/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.data.def.ThrowActivityDefinitionData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.FaultWithElement;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class Throw
extends AbstractBpelActivity {
    private static final long serialVersionUID = -4706956432645598341L;
    private static Logger log = Logger.getLogger(Throw.class.getName());
    private QName faultQName;
    private String faultVariable;

    public void executeActivity(BpelExecution execution) {
        execution.setPropagation(ExecutionImpl.Propagation.EXPLICIT);
        if (this.isBpelFault()) {
            BpelFaultException res = new BpelFaultException(this.faultQName);
            if (res != null) {
                log.fine("Bpel Fault thrown: " + res.getClass().getName());
                throw res;
            }
            throw new OrchestraRuntimeException("No Bpel Fault corresponds to this fault: " + this.getFaultName());
        }
        BpelFaultException userFault = this.getUserFaultVariable(execution);
        log.fine("User Fault thrown: " + userFault);
        throw userFault;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BpelFaultException getUserFaultVariable(BpelExecution execution) {
        BpelFaultException userFault = null;
        if (this.getFaultVariable() != null) {
            ScopeRuntime scopeRuntime = execution.getScopeRuntimeWithVariable(this.getFaultVariable());
            VariableRuntime faultV = scopeRuntime.getVariable(this.getFaultVariable());
            if (faultV == null) throw new OrchestraRuntimeException("The variable is unknown: " + this.getFaultVariable());
            Object val = faultV.getValue();
            if (val != null) {
                if (val instanceof Element) {
                    Element element = (Element)val;
                    userFault = new FaultWithElement(this.getFaultName(), element.getOwnerDocument());
                } else {
                    if (!(val instanceof MessageVariable)) throw new OrchestraRuntimeException("The type of the value of the variable is unknown: " + val.getClass());
                    MessageVariable message = ((MessageVariable)val).duplicate();
                    userFault = new FaultWithMessageVariable(this.getFaultName(), message);
                }
            }
        } else {
            userFault = new BpelFaultException(this.getFaultName());
        }
        if (userFault != null) return userFault;
        throw new OrchestraRuntimeException("No user fault corresponds to this fault: [name=" + this.getFaultName() + ", variable=" + this.getFaultVariable() + "]");
    }

    private boolean isBpelFault() {
        boolean res = false;
        if (this.getFaultName().getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/process/executable")) {
            res = true;
        }
        return res;
    }

    public QName getFaultName() {
        return this.faultQName;
    }

    public void setFaultName(QName faultName) {
        this.faultQName = faultName;
    }

    public String getFaultVariable() {
        return this.faultVariable;
    }

    public void setFaultVariable(String faultVariable) {
        this.faultVariable = faultVariable;
    }

    public ActivityType getType() {
        return ActivityType.THROW;
    }

    public ThrowActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ThrowActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name, this.faultQName, this.faultVariable);
    }
}

