/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.descriptor;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.ObjectName;
import org.hibernate.SessionFactory;
import org.hibernate.jmx.StatisticsService;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.internal.util.Listener;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.descriptor.HibernateSessionFactoryDescriptor;

public class OrchestraHibernateSessionFactoryDescriptor
extends HibernateSessionFactoryDescriptor {
    public Object construct(WireContext wireContext) {
        ObjectName on;
        SessionFactory sessionFactory = (SessionFactory)super.construct(wireContext);
        Properties orchestraProperties = (Properties)wireContext.get("orchestra-properties");
        String jmxObjectName = orchestraProperties.getProperty("orchestra.jmx.objectName");
        String domainName = jmxObjectName.substring(0, jmxObjectName.indexOf(":"));
        String mbeanName = this.getName();
        mbeanName = mbeanName.replace(",", "_");
        mbeanName = mbeanName.replace("=", "_");
        mbeanName = mbeanName.replace(":", "_");
        mbeanName = mbeanName.replace("'", "_");
        mbeanName = mbeanName.replace("*", "_");
        mbeanName = mbeanName.replace("?", "_");
        Hashtable<String, String> tb = new Hashtable<String, String>();
        tb.put("type", "Hibernate");
        tb.put("name", mbeanName);
        try {
            on = new ObjectName(domainName, tb);
            StatisticsService stats = new StatisticsService();
            stats.setSessionFactory(sessionFactory);
            ManagementFactory.getPlatformMBeanServer().registerMBean(stats, on);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't register mbeans", e);
        }
        wireContext.addListener(new SessionFactoryMBeanCloser(on));
        return sessionFactory;
    }

    public static class SessionFactoryMBeanCloser
    implements Listener {
        private final ObjectName objectName;

        public SessionFactoryMBeanCloser(ObjectName on) {
            this.objectName = on;
        }

        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                try {
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.objectName);
                }
                catch (Exception e) {
                    throw new OrchestraRuntimeException("Exception while unregistering mbean", e);
                }
            }
        }
    }
}

