/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoveProcessCommand
implements Command<Boolean> {
    private final ProcessDefinitionUUID pduuid;

    public RemoveProcessCommand(ProcessDefinitionUUID pduuid) {
        this.pduuid = pduuid;
    }

    @Override
    public Boolean execute(Environment environment) {
        if (this.pduuid == null) {
            throw new IllegalArgumentException("Process definition uuid is null");
        }
        Querier querier = EnvTool.getQuerier();
        if (EnvTool.getRepository().getProcess(this.pduuid) != null) {
            throw new OrchestraRuntimeException("Process " + this.pduuid + " is still deployed. Please undeploy it first.");
        }
        if (!querier.findProcessInstances(this.pduuid).isEmpty()) {
            throw new OrchestraRuntimeException("Some instances of process " + this.pduuid + " are not removed. Please remove instances first.");
        }
        return querier.removeProcessDefinition(this.pduuid) != null;
    }
}

