/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.Pick;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.OnAlarm;
import org.ow2.orchestra.definition.element.OnMessage;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.OnAlarmFullDefinition;
import org.ow2.orchestra.facade.def.full.OnMessageFullDefinition;
import org.ow2.orchestra.facade.def.full.PickActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.OnAlarmFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.OnMessageFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.PickActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.ForDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.UntilDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.ReceiveBinding;
import org.ow2.orchestra.parsing.binding.exception.CorrelationSetNotFoundException;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class PickBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(PickBinding.class.getName());

    public PickBinding() {
        super("pick", ActivityType.PICK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Element element, Parse parse, Parser parser) {
        Pick pick = new Pick();
        this.setEnclosingScope(pick, parse);
        this.parseStandardAttributes(element, pick, parse);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        PickActivityFullDefinition pickActivityFullDefinition = (PickActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
        ArrayList<OnMessageFullDefinition> onMessageFullDefinitionList = new ArrayList<OnMessageFullDefinition>();
        ArrayList<OnAlarmFullDefinition> onAlarmFullDefinitionList = new ArrayList<OnAlarmFullDefinition>();
        this.parseStandardElements(element, pick, parse);
        pick.setCreateInstance(BpelUtil.isCreateInstance(element));
        NodeImpl pickNode = this.createActivityNode(element, parse, parser, (ExternalActivity)pick);
        List<Element> onMessageElements = XmlUtil.elements(element, "onMessage");
        if (onMessageElements == null || onMessageElements.isEmpty()) {
            parse.addProblem("pick element " + element + "should contain at least one onMessage element.");
            return null;
        }
        List<Element> onAlarmElements = XmlUtil.elements(element, "onAlarm");
        if (onAlarmElements != null && !onAlarmElements.isEmpty() && pick.isCreateInstance()) {
            String message = StaticAnalysisFault.getMessage("SA00062", "  pick " + pick + " has a createInstance attribute with a value of yes. It must contain only onMessage events.");
            parse.addProblem(message, new StaticAnalysisException("SA00062"));
        }
        ArrayList<OnMessage> onMessages = new ArrayList<OnMessage>();
        ArrayList<OnAlarm> onAlarms = null;
        parse.pushObject(pickNode);
        try {
            for (Element onMessageElement : onMessageElements) {
                OnMessageFullDefinitionImpl onMessageFullDefinition = new OnMessageFullDefinitionImpl();
                OnMessage onMessage = this.parseOnMessage(onMessageElement, pickNode, pick, parse, parser, onMessageFullDefinition);
                onMessages.add(onMessage);
                onMessageFullDefinitionList.add(onMessageFullDefinition);
            }
            if (onAlarmElements != null) {
                onAlarms = new ArrayList<OnAlarm>();
                for (Element onAlarmElement : onAlarmElements) {
                    OnAlarmFullDefinitionImpl onAlarmFullDefinition = new OnAlarmFullDefinitionImpl();
                    OnAlarm onAlarm = this.parseOnAlarm(onAlarmElement, pickNode, pick, parse, parser, onAlarmFullDefinition);
                    onAlarms.add(onAlarm);
                    onAlarmFullDefinitionList.add(onAlarmFullDefinition);
                }
            }
        }
        finally {
            parse.popObject();
        }
        pick.setOnMessages(onMessages);
        pick.setOnAlarms(onAlarms);
        if (!onMessages.isEmpty()) {
            BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
            bpelProcess.addInboundMessageElement(pick);
        }
        pickActivityFullDefinition.setOnMessageDefinitionList(onMessageFullDefinitionList);
        pickActivityFullDefinition.setOnAlarmDefinitionList(onAlarmFullDefinitionList);
        pickActivityFullDefinition.setCreateInstance(pick.isCreateInstance());
        return pickNode;
    }

    public OnAlarm parseOnAlarm(Element element, NodeImpl pickNode, Pick pick, Parse parse, Parser parser, OnAlarmFullDefinition onAlarmFullDefinition) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        OnAlarm onAlarm = new OnAlarm();
        DefinitionKeeper defKeeper = parse.findObject(DefinitionKeeper.class);
        defKeeper.pushParent(onAlarmFullDefinition);
        onAlarm.setActivity(this.parseChildActivity(element, parse, parser));
        defKeeper.popParent();
        BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
        Element deadlineElement = XmlUtil.element(element, "until");
        Element durationElement = XmlUtil.element(element, "for");
        if (durationElement != null && deadlineElement != null) {
            parse.addProblem("Error in element: " + element + " only one element 'for' or 'until' should be used.");
        }
        if (durationElement != null) {
            Expression expression = PickBinding.parseExpression(durationElement, bpelProcess);
            onAlarm.setDurationExpression(expression);
            ForDefinitionImpl forDefinition = new ForDefinitionImpl(expression.getLanguage(), durationElement.getTextContent());
            onAlarmFullDefinition.setForDefinition(forDefinition);
        } else if (deadlineElement != null) {
            Expression expression = PickBinding.parseExpression(deadlineElement, bpelProcess);
            onAlarm.setDeadlineExpression(expression);
            UntilDefinitionImpl untilDefinition = new UntilDefinitionImpl(expression.getLanguage(), deadlineElement.getTextContent());
            onAlarmFullDefinition.setUntilDefinition(untilDefinition);
        } else {
            parse.addProblem("Error in element: " + element + " one element 'for' or 'until' should be used.");
        }
        return onAlarm;
    }

    public OnMessage parseOnMessage(Element element, NodeImpl pickNode, Pick pick, Parse parse, Parser parser, OnMessageFullDefinition onMessageFullDefinition) {
        OperationKey operationKey;
        PartnerLink partnerLink;
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        OnMessage onMessage = new OnMessage();
        String variable = XmlUtil.attribute(element, "variable");
        String partnerLinkName = XmlUtil.attribute(element, "partnerLink");
        String operation = XmlUtil.attribute(element, "operation");
        onMessage.setVariable(variable);
        onMessage.setPartnerLinkName(partnerLinkName);
        onMessageFullDefinition.setOperation(operation);
        onMessageFullDefinition.setPartnerLink(partnerLinkName);
        onMessageFullDefinition.setVariable(variable);
        String messageExchange = XmlUtil.attribute(element, "messageExchange");
        if (messageExchange != null) {
            onMessage.setMessageExchange(messageExchange);
            onMessageFullDefinition.setMessageExchange(messageExchange);
        }
        if ((partnerLink = this.findPartnerLinkDefinition(parse, partnerLinkName)) == null) {
            parse.addProblem("No partnerLink " + partnerLinkName + " defined.");
            return null;
        }
        QName plportType = partnerLink.getMyRolePortTypeQName();
        if (plportType == null) {
            parse.addProblem("No myRole defined for partnerLink: " + partnerLinkName);
            return null;
        }
        BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
        onMessage.setOperationKey(new OperationKey(bpelProcess.getUUID(), plportType, operation));
        Operation operationWsdl = bpelProcess.getWsdlInfos().getPortType(plportType).getOperation(operation, null, null);
        if (operationWsdl != null && operationWsdl.getInput() != null) {
            onMessage.setInputMessageType(operationWsdl.getInput().getMessage().getQName());
        }
        if (XmlUtil.attribute(element, "portType") != null && !plportType.equals(XmlUtil.attributeQName(element, "portType"))) {
            String message = StaticAnalysisFault.getMessage("SA00005", "  onMessage " + onMessage + " has specified a PortType that is different from the one specified by the partnerLink");
            parse.addProblem(message, new StaticAnalysisException("SA00005"));
        }
        onMessageFullDefinition.setPortType(onMessage.getPortTypeQName());
        Element fromPartsElement = XmlUtil.element(element, "fromParts");
        if (fromPartsElement != null) {
            if (onMessage.getVariable() != null) {
                String message = StaticAnalysisFault.getMessage("SA00063", "  onMessage " + onMessage + " has specified both a Variable and a fromPart");
                parse.addProblem(message, new StaticAnalysisException("SA00063"));
            }
            List<Element> fromPartElements = XmlUtil.elements(fromPartsElement, "fromPart");
            onMessage.setAnonymousInboundMessageVariable(ReceiveBinding.getAnonymousVariable(onMessage, parse));
            List<Copy> inCopies = ReceiveBinding.getInCopies(fromPartElements, pick.getEnclosingScope(), parse, onMessageFullDefinition);
            if (inCopies.size() != 0) {
                onMessage.setInCopies(inCopies);
            }
        }
        DefinitionKeeper defKeeper = parse.findObject(DefinitionKeeper.class);
        defKeeper.pushParent(onMessageFullDefinition);
        Element correlationsElement = XmlUtil.element(element, "correlations");
        if (correlationsElement != null) {
            List<Element> correlationElements = XmlUtil.elements(correlationsElement, "correlation");
            try {
                onMessage.setCorrelations(ReceiveBinding.parseCorrelations(correlationElements, (Scope)pick.getEnclosingScope(), parse, onMessageFullDefinition));
            }
            catch (CorrelationSetNotFoundException e) {
                parse.addProblem("A correlation has not been defined in enclosing scopes", e);
            }
        }
        if (pick.isCreateInstance() && bpelProcess.addStartElement(operationKey = onMessage.getOperationKey(), pick) != null) {
            parse.addProblem("More than one start activity found for operationKey: " + operationKey + ". This is not allowed.", new StaticAnalysisException("SA10001"));
        }
        onMessage.setActivity(this.parseChildActivity(element, parse, parser));
        onMessage.setInboundMessageElement(pick);
        defKeeper.popParent();
        return onMessage;
    }

    protected static Expression parseExpression(Element element, BpelProcess bpelProcess) {
        String expressionLanguage = XmlUtil.attribute(element, "expressionLanguage");
        if (expressionLanguage == null) {
            expressionLanguage = bpelProcess.getExpressionLanguage();
        }
        Expression expression = new Expression();
        expression.setLanguage(expressionLanguage);
        expression.setNamespaces(BpelUtil.getAllNameSpaces(element));
        expression.setText(element.getTextContent());
        return expression;
    }

    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new PickActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

