/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.BaseCatchActivity;
import org.ow2.orchestra.definition.activity.IAbstractActivity;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.job.TimerImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.job.Job;
import org.ow2.orchestra.pvm.job.Timer;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.pvm.model.OpenExecution;
import org.ow2.orchestra.pvm.session.MessageSession;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.FlowRuntime;
import org.ow2.orchestra.runtime.ForEachRuntime;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.services.CheckHasMessageJob;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReplierKey;
import org.ow2.orchestra.services.itf.Replier;
import org.ow2.orchestra.services.job.BpelTimerImpl;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.wsdl.PartnerLinkType;
import org.ow2.orchestra.wsdl.Property;
import org.ow2.orchestra.wsdl.PropertyAlias;
import org.ow2.orchestra.wsdl.WsdlsInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelExecution
extends ExecutionImpl {
    public static final String ADDITIONNAL_SCOPE_VARIABLES = "additionnalScopeVariables";
    public static final String SCOPE_STATE_VARIABLE = "scopeState";
    private static final long serialVersionUID = 1L;
    protected ProcessInstanceUUID processInstanceUUID;
    protected ActivityInstanceUUID activityInstanceUUID;
    protected Date startedDate;
    private static Logger log = Logger.getLogger(BpelExecution.class.getName());
    protected FlowRuntime flowRuntime;
    protected ForEachRuntime forEachRuntime;
    protected ScopeRuntime scopeRuntime;
    protected Set<Replier> repliers = new HashSet<Replier>();
    protected WaitingExecution waitingExecution;
    protected ActivityState instanceState = null;
    protected String resumeState;

    public BpelExecution() {
        this.id = UUID.randomUUID().toString();
    }

    @Override
    protected BpelExecution newChildExecution() {
        BpelExecution child = new BpelExecution();
        child.setProcessInstanceUUID(this.processInstanceUUID);
        child.setActivityInstanceUUID(this.activityInstanceUUID);
        child.setStartedDate(this.startedDate);
        EnvTool.getRepository().storeExecution(child);
        return child;
    }

    @Override
    public BpelExecution getParent() {
        return (BpelExecution)super.getParent();
    }

    @Override
    public BpelExecution getProcessInstance() {
        return (BpelExecution)super.getProcessInstance();
    }

    public FlowRuntime getFlowRuntimeWithLink(String linkName) {
        FlowRuntime fr = this.getFlowRuntime();
        if (fr != null && fr.hasLink(linkName)) {
            return fr;
        }
        if (this.getParent() != null) {
            return this.getParent().getFlowRuntimeWithLink(linkName);
        }
        return null;
    }

    public ScopeRuntime getCurrentScopeRuntime() {
        if (this.scopeRuntime != null) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getCurrentScopeRuntime();
        }
        return null;
    }

    public ScopeRuntime getScopeRuntimeWithVariable(String variableName) {
        if (this.scopeRuntime != null && this.scopeRuntime.containsVariable(variableName)) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getScopeRuntimeWithVariable(variableName);
        }
        return null;
    }

    public ScopeRuntime getScopeRuntimeWithCS(String csName) {
        if (this.scopeRuntime != null && this.scopeRuntime.containsCorrelationSet(csName)) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getScopeRuntimeWithCS(csName);
        }
        return null;
    }

    public ScopeRuntime getScopeRuntimeWithPLNK(String partnerLinkName) {
        if (this.scopeRuntime != null && this.scopeRuntime.getPartnerLink(partnerLinkName) != null) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getScopeRuntimeWithPLNK(partnerLinkName);
        }
        return null;
    }

    public ScopeRuntime getScopeRuntimeWithScope(IAbstractActivity scope) {
        if (this.scopeRuntime != null && this.scopeRuntime.getScopeDefinition().equals(scope)) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getScopeRuntimeWithScope(scope);
        }
        return null;
    }

    public void setLinkStatus(String linkName, Boolean linkStatus) {
        FlowRuntime fr = this.getFlowRuntimeWithLink(linkName);
        fr.setLinkStatus(linkName, linkStatus);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("BpelExecution");
        if (this.node != null) {
            IAbstractActivity activity = (IAbstractActivity)this.node.getBehaviour();
            sb.append('[');
            sb.append(activity.getName());
            sb.append(']');
        }
        sb.append(this.hashCode());
        return sb.toString();
    }

    @Override
    public BpelProcess getProcessDefinition() {
        return (BpelProcess)this.processDefinition;
    }

    public PartnerLinkRuntime getPartnerLinkRuntime(String partnerLinkName) {
        ScopeRuntime scopeRuntime = this.getScopeRuntimeWithPLNK(partnerLinkName);
        if (scopeRuntime != null) {
            return scopeRuntime.getPartnerLink(partnerLinkName);
        }
        return null;
    }

    public Object getVariableValue(String variableName) {
        VariableRuntime variable = this.getVariableByName(variableName);
        return variable.getValue();
    }

    public VariableRuntime getVariableByName(String variableName) {
        ScopeRuntime currentRuntimeScope;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Getting variable " + variableName);
        }
        if ((currentRuntimeScope = this.getScopeRuntimeWithVariable(variableName)) != null) {
            return currentRuntimeScope.getVariable(variableName);
        }
        return null;
    }

    public CorrelationSetRuntime getCorrelationSetByName(String csName) {
        ScopeRuntime scopeRuntime;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Getting CorrelationSet " + csName);
        }
        if ((scopeRuntime = this.getScopeRuntimeWithCS(csName)) != null) {
            return scopeRuntime.getCorrelationSet(csName);
        }
        return null;
    }

    public PartnerLinkType getPartnerLinkType(QName partnerLinkTypeName) {
        return this.getWsdlInfos().getPartnerLinkType(partnerLinkTypeName);
    }

    public Property getProperty(QName propertyQName) {
        return this.getWsdlInfos().getProperty(propertyQName);
    }

    public PropertyAlias getPropertyAliasWithMessageType(QName propertyName, QName messageType) {
        return this.getWsdlInfos().getPropertyAliasWithMessageType(propertyName, messageType);
    }

    public List<PropertyAlias> getPropertyAliasesWithMessageType(QName messageType) {
        return this.getWsdlInfos().getPropertyAliasesWithMessageType(messageType);
    }

    public List<PropertyAlias> getPropertyAliases(CorrelationSet cs, QName messageType) {
        return this.getWsdlInfos().getPropertyAliases(cs.getProperties().values(), messageType);
    }

    public PropertyAlias getPropertyAliasWithElement(QName propertyName, QName element) {
        return this.getWsdlInfos().getPropertyAliasWithElement(propertyName, element);
    }

    public PropertyAlias getPropertyAliasWithType(QName propertyName, QName type) {
        return this.getWsdlInfos().getPropertyAliasWithType(propertyName, type);
    }

    private WsdlsInfos getWsdlInfos() {
        return this.getProcessDefinition().getWsdlInfos();
    }

    public void pushFlowRuntime(FlowRuntime flowRuntime) {
        if (this.flowRuntime == null) {
            this.flowRuntime = flowRuntime;
        } else {
            Misc.unreachableStatement("One execution should have only one flowRuntime runtime");
        }
    }

    public FlowRuntime getFlowRuntime() {
        return this.flowRuntime;
    }

    public void pushForEachRuntime(ForEachRuntime forEachRuntime) {
        if (this.forEachRuntime != null) {
            Misc.unreachableStatement("One execution should have only one foreach runtime");
        }
        this.forEachRuntime = forEachRuntime;
    }

    public ForEachRuntime getForEachRuntime() {
        return this.forEachRuntime;
    }

    public void pushScopeRuntime(ScopeRuntime scopeRuntime) {
        if (this.scopeRuntime != null) {
            Misc.unreachableStatement("One execution should have only one scopeRuntime");
        }
        this.scopeRuntime = scopeRuntime;
    }

    public ScopeRuntime popScopeRuntime(boolean shouldAdd) {
        if (this.scopeRuntime == null) {
            Misc.unreachableStatement("There is no scopeRuntime to pop!");
        }
        ScopeRuntime res = this.scopeRuntime;
        this.scopeRuntime = null;
        if (shouldAdd) {
            ScopeRuntime parent = this.getCurrentScopeRuntime();
            if (parent == null) {
                Misc.unreachableStatement("parent is null");
            }
            parent.addEndedChild(res);
        }
        return res;
    }

    public ScopeRuntime getScopeRuntime() {
        return this.scopeRuntime;
    }

    public Replier getReplier(OperationKey operationKey, String messageExchange) {
        if (this.scopeRuntime != null) {
            ReplierKey replierKey = new ReplierKey(operationKey, messageExchange, this.scopeRuntime);
            Iterator<Replier> replierIterator = this.getRepliers().iterator();
            while (replierIterator.hasNext()) {
                Replier replier = replierIterator.next();
                if (!replier.getReplierKey().equals(replierKey)) continue;
                replierIterator.remove();
                return replier;
            }
        }
        if (this.parent != null) {
            return this.getParent().getReplier(operationKey, messageExchange);
        }
        return null;
    }

    public Set<Replier> getRepliers() {
        if (this.getParent() != null) {
            return this.getProcessInstance().getRepliers();
        }
        return this.repliers;
    }

    public void addReplier(Replier replier) {
        this.getRepliers().add(replier);
    }

    public void setWaitingExecution(WaitingExecution waitingExecution) {
        this.waitingExecution = waitingExecution;
    }

    public void resetWaitingExecution() {
        this.waitingExecution = null;
    }

    public WaitingExecution getWaitingExecution() {
        return this.waitingExecution;
    }

    public boolean hasWaitingExecution() {
        return this.waitingExecution != null;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BpelExecution)) {
            return obj.equals(this);
        }
        BpelExecution other = (BpelExecution)obj;
        return other.getId().equals(this.id);
    }

    public Set<BpelExecution> searchWaitingExecutions() {
        HashSet<BpelExecution> res = new HashSet<BpelExecution>();
        if (this.hasWaitingExecution()) {
            res.add(this);
        }
        if (this.getExecutions() != null) {
            for (OpenExecution child : this.getExecutions()) {
                res.addAll(((BpelExecution)child).searchWaitingExecutions());
            }
        }
        return res;
    }

    @Override
    public void createTimer(String eventName, String signalName, String dueDateDescription, Date dueDate, String repeat, Boolean isExclusive, Integer retries) {
        super.createTimer(eventName, signalName, dueDateDescription, dueDate, repeat, isExclusive, retries);
    }

    @Override
    protected TimerImpl instantiateTimer() {
        return new BpelTimerImpl();
    }

    public void terminate() {
        Collection<OpenExecution> childExecutions;
        ActivityType activityType = ((IAbstractActivity)this.node.getBehaviour()).getType();
        log.finest("Terminating BpelExecution " + this + ", activity type " + (Object)((Object)activityType) + ", node name " + this.node.getName());
        if (this.scopeRuntime != null && !ActivityType.SCOPE.equals((Object)activityType)) {
            Misc.unreachableStatement("The execution " + this + " has a scopeRuntime but is not a " + (Object)((Object)ActivityType.SCOPE) + " (it is a " + (Object)((Object)activityType) + ")");
        }
        if (this.scopeRuntime == null && ActivityType.SCOPE.equals((Object)activityType)) {
            Misc.unreachableStatement("The execution " + this + " doen't have any scopeRuntime but is a " + (Object)((Object)activityType));
        }
        if (this.scopeRuntime != null) {
            log.finest("Scope state for BpelExecution " + this + " is " + (Object)((Object)this.scopeRuntime.getState()));
        }
        if ((childExecutions = this.getExecutions()) != null && !childExecutions.isEmpty()) {
            BpelExecution childBpelExecution = (BpelExecution)childExecutions.iterator().next();
            log.finest("Terminating child " + childBpelExecution + " out of " + childExecutions.size() + " children");
            childBpelExecution.terminate();
            return;
        }
        if (ActivityType.SCOPE.equals((Object)activityType) && ScopeState.HANDLING_FAULT.equals((Object)this.scopeRuntime.getState())) {
            Node faultHandler;
            List<Node> nodes = this.node.getNodes();
            if (nodes == null) {
                Misc.unreachableStatement("The parent scope node doesn't have any children");
            }
            if (nodes.size() < 5) {
                Misc.unreachableStatement("The parent scope node has only " + nodes.size() + " children, it should have had at least " + 5);
            }
            if ((faultHandler = BaseCatchActivity.findFaultHandler(this.scopeRuntime, nodes, this.scopeRuntime.getLastException())) == null) {
                faultHandler = nodes.get(4);
            }
            log.finest("Will execute the fault handler " + faultHandler + " in BpelExecution " + this);
            this.createExecution().execute(faultHandler);
        } else {
            if (ActivityType.SCOPE.equals((Object)activityType) && (ScopeState.RUNNING.equals((Object)this.scopeRuntime.getState()) || ScopeState.RETHROWING_FAULT.equals((Object)this.scopeRuntime.getState()))) {
                this.scopeRuntime.setState(ScopeState.TERMINATING);
                List<Node> nodes = this.node.getNodes();
                if (nodes == null) {
                    Misc.unreachableStatement("The scope node " + this.node + " doesn't have any children");
                }
                if (nodes.size() < 5) {
                    Misc.unreachableStatement("The scope node " + this.node + " has only " + nodes.size() + " children, it should have had at least " + 5);
                }
                Node terminationHandler = nodes.get(2);
                ExecutionImpl terminationHandlerExecution = this.createExecution();
                log.finest("Will execute the termination handler " + terminationHandler + " in BpelExecution " + terminationHandlerExecution + " for the BpelExecution " + this);
                terminationHandlerExecution.execute(terminationHandler);
                return;
            }
            if (ActivityType.FOR_EACH.equals((Object)activityType) && this.getForEachRuntime() != null && this.getForEachRuntime().isCompleted()) {
                this.signal("all-finished");
            } else if (ActivityType.COMPENSATION_HANDLER.equals((Object)activityType) && this.getParent().getScopeRuntime() != null) {
                if (this.getParent().getScopeRuntime().getLastException() != null) {
                    BpelExecution chExecution = this.getParent();
                    chExecution.removeExecution(this);
                    chExecution.end("ended");
                    ScopeRuntime scopeRuntime = chExecution.popScopeRuntime(false);
                    scopeRuntime.setState(ScopeState.COMPENSATED);
                    BpelExecution compensateExecution = scopeRuntime.getCompensateExecution();
                    scopeRuntime.setCompensateExecution(null);
                    BpelExecution parentExecution = chExecution.getParent();
                    parentExecution.removeExecution(chExecution);
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("exception", scopeRuntime.getLastException());
                    compensateExecution.signal(params);
                }
            } else if (ActivityType.SCOPE_EVENT_HANDLER.equals((Object)activityType)) {
                this.removeExecution();
                if (this.getState().equals("async")) {
                    this.unlock();
                    this.end("ended");
                } else {
                    this.end("cancelled");
                }
                if (this.parent != null) {
                    log.finest("Terminating parent " + this.parent);
                    ((BpelExecution)this.parent).terminate();
                }
            } else {
                this.removeExecution();
                if (this.getState().equals("async")) {
                    this.unlock();
                    this.end("ended");
                } else {
                    this.end("cancelled");
                    if (this.parent != null && this.parent.getNode() != this.getNode()) {
                        IAbstractActivity activity = (IAbstractActivity)this.getNode().getBehaviour();
                        EnvTool.getRecorder().recordActivityTerminated(activity.createRuntimeData(this));
                    }
                }
                if (this.parent != null) {
                    log.finest("Terminating parent " + this.parent);
                    ((BpelExecution)this.parent).terminate();
                }
            }
        }
    }

    public void exit() {
        if (this.isSuspended()) {
            this.setState(this.resumeState);
        }
        this.removeExecution();
        Collection<OpenExecution> childExecutions = this.getExecutions();
        if (childExecutions != null) {
            for (OpenExecution childExecution : new ArrayList<OpenExecution>(childExecutions)) {
                BpelExecution childBpelExecution = (BpelExecution)childExecution;
                childBpelExecution.exit();
            }
        }
        if (this.getState().equals("async")) {
            this.unlock();
            this.end("ended");
        } else if (!this.isFinished()) {
            this.end("cancelled");
            if (this.getParent() != null && this.getParent().getNode() != this.getNode()) {
                IAbstractActivity activity = (IAbstractActivity)this.getNode().getBehaviour();
                EnvTool.getRecorder().recordActivityExited(activity.createRuntimeData(this));
            }
        }
    }

    private void removeExecution() {
        this.resetWaitingExecution();
        this.removeJobs();
        if (this.parent != null) {
            this.setPropagation(ExecutionImpl.Propagation.EXPLICIT);
            this.parent.removeExecution(this);
        } else {
            this.setProcessInstanceState(ActivityState.EXITED);
        }
    }

    public ProcessInstanceUUID getProcessInstanceUUID() {
        return this.processInstanceUUID;
    }

    public void setProcessInstanceUUID(ProcessInstanceUUID processInstanceUUID) {
        this.processInstanceUUID = processInstanceUUID;
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        return this.activityInstanceUUID;
    }

    public ActivityInstanceUUID getEncloserActivityInstanceUUID() {
        return this.getEncloserActivityInstanceUUID(this.getActivityInstanceUUID());
    }

    private ActivityInstanceUUID getEncloserActivityInstanceUUID(ActivityInstanceUUID enclosedActivityUUID) {
        ActivityInstanceUUID activityInstanceUUID = this.getActivityInstanceUUID();
        BpelExecution parentBpelExecution = this.getParent();
        if (enclosedActivityUUID.equals(activityInstanceUUID)) {
            if (parentBpelExecution == null) {
                return null;
            }
            return parentBpelExecution.getEncloserActivityInstanceUUID(enclosedActivityUUID);
        }
        return activityInstanceUUID;
    }

    public void setActivityInstanceUUID(ActivityInstanceUUID activityInstanceUUID) {
        this.activityInstanceUUID = activityInstanceUUID;
    }

    public Date getStartedDate() {
        return this.startedDate;
    }

    public void setStartedDate(Date startedDate) {
        this.startedDate = startedDate;
    }

    public ProcessInstanceData getProcessInstanceData() {
        return new ProcessInstanceData(this.getProcessDefinition().getProcessDefinitionData(), this.getProcessInstanceUUID(), this.getProcessInstanceState());
    }

    public boolean isInstanceSuspended() {
        return ActivityState.SUSPENDED.equals((Object)this.getProcessInstanceState());
    }

    public void suspendInstance() {
        if (ActivityState.RUNNING.equals((Object)this.getProcessInstanceState())) {
            this.suspend((BpelExecution)this.processInstance);
            this.setProcessInstanceState(ActivityState.SUSPENDED);
            EnvTool.getRecorder().recordInstanceUpdated(this.getProcessInstanceData());
        }
    }

    public void resumeInstance() {
        if (ActivityState.SUSPENDED.equals((Object)this.getProcessInstanceState())) {
            this.resume((BpelExecution)this.processInstance);
            this.setProcessInstanceState(ActivityState.RUNNING);
            EnvTool.getRecorder().recordInstanceUpdated(this.getProcessInstanceData());
        }
    }

    private void resume(BpelExecution node) {
        if (node.getResumeState().equals("active")) {
            IAbstractActivity activity = (IAbstractActivity)node.getNode().getBehaviour();
            if (activity.getType().equals((Object)ActivityType.PICK)) {
                boolean removeOnMessage = false;
                Iterator<JobImpl<?>> jobs = node.getJobs().iterator();
                while (jobs.hasNext() && !removeOnMessage) {
                    Job j = jobs.next();
                    if (j instanceof Timer) {
                        if (!j.getDueDate().before(new Date(System.currentTimeMillis()))) continue;
                        removeOnMessage = true;
                        continue;
                    }
                    if (!(j instanceof CheckHasMessageJob)) continue;
                    jobs.remove();
                }
                if (removeOnMessage) {
                    node.resetWaitingExecution();
                } else {
                    Environment.getFromCurrent(MessageSession.class).send(new CheckHasMessageJob(node));
                }
            } else if (activity.isInboundMessageElement()) {
                node.removeJobs();
                Environment.getFromCurrent(MessageSession.class).send(new CheckHasMessageJob(node));
            }
        }
        for (OpenExecution n : node.getExecutions()) {
            this.resume((BpelExecution)n);
        }
        if (node.isSuspended()) {
            this.resumeJobs(node);
            if (node.isSuspended()) {
                node.setState(node.getResumeState());
            }
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Node " + node + " now running.");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Node " + node + " is already running.");
        }
    }

    private void suspend(BpelExecution node) {
        if (!node.getExecutions().isEmpty()) {
            for (OpenExecution n : node.getExecutions()) {
                this.suspend((BpelExecution)n);
            }
        }
        if (!node.isSuspended()) {
            node.setResumeState(node.getState());
            node.setState("suspended");
            this.suspendJobs(node);
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Node " + node + " suspended.");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Node " + node + " is already suspended.");
        }
    }

    private void suspendJobs(OpenExecution node) {
        for (Job job : node.getJobs()) {
            JobImpl job2 = (JobImpl)job;
            job2.setSuspended(true);
            if (job2.getLockOwner() == null) continue;
            job2.setLockOwner(null);
            job2.setLockExpirationTime(null);
        }
    }

    private void resumeJobs(OpenExecution node) {
        for (Job job : node.getJobs()) {
            JobImpl job2 = (JobImpl)job;
            job2.setSuspended(false);
            if (job2.getLockOwner() == null) continue;
            job2.setLockOwner(null);
            job2.setLockExpirationTime(null);
        }
    }

    public void removeJob(Job job) {
        Environment.getFromCurrent(JobDbSession.class).delete(job);
    }

    public void removeJobs() {
        for (Job job : new HashSet(this.getJobs())) {
            Environment.getFromCurrent(JobDbSession.class).delete(job);
        }
    }

    public ActivityState getProcessInstanceState() {
        if (this.getParent() == null) {
            return this.instanceState;
        }
        return this.getProcessInstance().getProcessInstanceState();
    }

    public void setProcessInstanceState(ActivityState state) {
        if (this.getParent() == null) {
            this.instanceState = state;
        } else {
            this.getProcessInstance().setProcessInstanceState(state);
        }
    }

    public String getResumeState() {
        return this.resumeState;
    }

    public void setResumeState(String resumeState) {
        this.resumeState = resumeState;
    }

    @Override
    public void removeExecution(Execution child) {
        super.removeExecution(child);
        ((BpelExecution)child).resetWaitingExecution();
        ((BpelExecution)child).removeJobs();
        EnvTool.getRepository().removeExecution(child);
    }
}

