/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.HashSet;
import java.util.Set;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.services.ReceivingElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitingExecution {
    protected long dbid;
    protected int dbversion;
    protected BpelExecution bpelExecution;
    protected Set<CorrelationSetRuntime> correlationSetRuntimes;
    protected InboundMessageElement inboundMessageElement;

    protected WaitingExecution() {
    }

    public WaitingExecution(BpelExecution bpelExecution, InboundMessageElement inboundMessageElement) {
        this.bpelExecution = bpelExecution;
        this.correlationSetRuntimes = new HashSet<CorrelationSetRuntime>();
        for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
            for (Correlation correlation : receivingElement.getCorrelations()) {
                String correlationSetName = correlation.getCorrelationSet().getName();
                CorrelationSetRuntime csRuntime = bpelExecution.getCorrelationSetByName(correlationSetName);
                if (csRuntime == null) {
                    throw new OrchestraRuntimeException("CorrelationSetRuntime " + correlationSetName + " not found");
                }
                this.correlationSetRuntimes.add(csRuntime);
            }
        }
        this.inboundMessageElement = inboundMessageElement;
    }

    public BpelExecution getBpelExecution() {
        return this.bpelExecution;
    }

    public Set<CorrelationSetRuntime> getCorrelationSetRuntimes() {
        return this.correlationSetRuntimes;
    }

    public InboundMessageElement getInboundMessageElement() {
        return this.inboundMessageElement;
    }

    public String toString() {
        return "WaitingExecution[" + this.dbid + "]";
    }

    public static interface WaitingExecutionIterator {
        public WaitingExecution next();
    }
}

