/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.transaction.Synchronization;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;

public class MessageCarrierImpl
implements MessageCarrier {
    private final Object lock = new Object();
    private MessageVariable message;
    private QName faultQName;
    private boolean hasMessage = false;
    private boolean isEnded = false;
    private final String uuid = UUID.randomUUID().toString();

    public MessageVariable getMessage() {
        try {
            return this.getMessage(0L);
        }
        catch (TimeoutException e) {
            Misc.unreachableStatement("No timeout should occur");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageVariable getMessage(long timeout) throws TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isEnded) {
                try {
                    this.lock.wait(timeout);
                    if (!this.isEnded) {
                        throw new TimeoutException("Timeout occured while waiting for message");
                    }
                }
                catch (InterruptedException e) {
                    throw new OrchestraRuntimeException(e);
                }
            }
            if (!this.hasMessage) {
                throw new OrchestraRuntimeException("Process or scope is ended but no reply message available");
            }
            return this.message;
        }
    }

    public QName getFaultQName() {
        return this.faultQName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyFaultMessage(QName faultQName, MessageVariable messageToSend) {
        Object object = this.lock;
        synchronized (object) {
            this.faultQName = faultQName;
            this.message = messageToSend;
            this.hasMessage = true;
            this.isEnded = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyMessage(MessageVariable messageToSend) {
        Object object = this.lock;
        synchronized (object) {
            this.message = messageToSend;
            this.hasMessage = true;
            this.isEnded = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noReplyException() {
        Object object = this.lock;
        synchronized (object) {
            this.hasMessage = false;
            this.isEnded = true;
            this.lock.notifyAll();
        }
    }

    public void setMessage(final MessageVariable messageToSend) {
        Transaction tx = Environment.getCurrent().get(Transaction.class);
        if (tx != null) {
            Synchronization synchro = new Synchronization(){
                private final MessageVariable msg;
                {
                    this.msg = messageToSend.duplicate();
                }

                public void beforeCompletion() {
                    if (MessageCarrierImpl.this.isEnded) {
                        throw new OrchestraRuntimeException("Message already associated");
                    }
                }

                public void afterCompletion(int status) {
                    if (status == 3) {
                        MessageCarrierImpl.this.replyMessage(this.msg);
                    }
                }
            };
            tx.registerSynchronization(synchro);
        } else {
            this.replyMessage(messageToSend);
        }
    }

    public void setFaultMessage(final QName faultQName, final MessageVariable messageToSend) {
        Transaction tx = Environment.getCurrent().get(Transaction.class);
        if (tx != null) {
            Synchronization synchro = new Synchronization(){
                private final MessageVariable msg;
                {
                    this.msg = messageToSend.duplicate();
                }

                public void beforeCompletion() {
                    if (MessageCarrierImpl.this.isEnded) {
                        throw new OrchestraRuntimeException("Message already associated");
                    }
                }

                public void afterCompletion(int status) {
                    if (status == 3) {
                        MessageCarrierImpl.this.replyFaultMessage(faultQName, this.msg);
                    }
                }
            };
            tx.registerSynchronization(synchro);
        } else {
            this.replyFaultMessage(faultQName, messageToSend);
        }
    }

    public void throwMissingReply() {
        Transaction tx = Environment.getCurrent().get(Transaction.class);
        if (tx != null) {
            Synchronization synchro = new Synchronization(){

                public void beforeCompletion() {
                    if (MessageCarrierImpl.this.isEnded) {
                        throw new OrchestraRuntimeException("Message already associated");
                    }
                }

                public void afterCompletion(int status) {
                    if (status == 3) {
                        MessageCarrierImpl.this.noReplyException();
                    }
                }
            };
            tx.registerSynchronization(synchro);
        } else {
            this.noReplyException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessage() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFault() {
        Object object = this.lock;
        synchronized (object) {
            return this.faultQName != null;
        }
    }

    public String getUuid() {
        return this.uuid;
    }
}

