/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.runtime;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.VariableUpdate;
import org.ow2.orchestra.facade.runtime.WaitingActivity;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.PickActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.ScopeActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.SequenceActivityFullInstance;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.wait.WaitTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

public abstract class AbstractSubTypesPickTest
extends WaitTestCase {
    private ProcessInstanceUUID processFullInstanceUUID;
    private ProcessFullInstance processFullInstance;

    public abstract Querier getQuerier();

    public AbstractSubTypesPickTest(BpelTestCase.EnvironmentType environmentType) {
        super("http://example.com/pick2", "pick2", environmentType);
    }

    public void testSubTypesPick() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource("subtypestestpick.bpel"), ((Object)((Object)this)).getClass().getResource("subtypestestpick.wsdl"));
    }

    public long launch() {
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("st", BpelXmlUtil.createElementWithContent((String)"pick1"));
        final BpelTestCase.CallResult callResult1 = this.call(parts, portTypeQName, "submit");
        this.call(parts, portTypeQName, "op1");
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getJournalQueriers();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                AbstractSubTypesPickTest.this.processFullInstance = (ProcessFullInstance)processFullInstanceSet.iterator().next();
                AbstractSubTypesPickTest.this.processFullInstanceUUID = AbstractSubTypesPickTest.this.processFullInstance.getUUID();
                return null;
            }
        });
        parts.put("st", BpelXmlUtil.createElementWithContent((String)"pick2"));
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                callResult1.getMessageCarrier().getMessage();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Querier querier = AbstractSubTypesPickTest.this.getQuerier();
                ProcessFullInstance endedProcessFullInstance = querier.getProcessInstance(AbstractSubTypesPickTest.this.processFullInstanceUUID);
                Assert.assertNotNull((Object)endedProcessFullInstance);
                Assert.assertEquals((Object)ActivityType.PROCESS, (Object)endedProcessFullInstance.getType());
                ActivityFullInstance enclosedActivityInstance = endedProcessFullInstance.getEnclosedActivity();
                Assert.assertEquals((Object)ActivityType.SEQUENCE, (Object)enclosedActivityInstance.getType());
                SequenceActivityFullInstance sequenceActivityFullInstance = (SequenceActivityFullInstance)enclosedActivityInstance.fullCopy();
                List sequenceEnclosedActivities = sequenceActivityFullInstance.getEnclosedActivities();
                Assert.assertEquals((int)4, (int)sequenceEnclosedActivities.size());
                for (ActivityFullInstance activityFullInstance : sequenceEnclosedActivities) {
                    if (ActivityType.PICK.equals((Object)activityFullInstance.getType())) {
                        AbstractSubTypesPickTest.this.checkPick(activityFullInstance);
                    }
                    if (!ActivityType.SCOPE.equals((Object)activityFullInstance.getType())) continue;
                    AbstractSubTypesPickTest.this.checkScopeVariables(activityFullInstance);
                    AbstractSubTypesPickTest.this.checkPick(((ScopeActivityFullInstance)activityFullInstance).getEnclosedActivity());
                }
                AbstractSubTypesPickTest.this.deleteInstance(callResult1);
                return null;
            }
        });
        return endTime;
    }

    public void checkPick(ActivityFullInstance activityFullInstance) {
        PickActivityFullInstance pickActivityInstance = (PickActivityFullInstance)activityFullInstance.fullCopy();
        List waitingActivityList = pickActivityInstance.getWaitingActivityList();
        pickActivityInstance.getEnclosedActivity();
        Iterator waitingActivityIterator = waitingActivityList.iterator();
        if (pickActivityInstance.getWaitingActivityList().size() == 2) {
            Assert.assertEquals((Object)ActivityType.ASSIGN, (Object)pickActivityInstance.getEnclosedActivity().getType());
            while (waitingActivityIterator.hasNext()) {
                WaitingActivity waitingActivity = (WaitingActivity)waitingActivityIterator.next();
                Assert.assertNotNull((Object)waitingActivity.getExpectedStartedDate());
            }
        } else if (pickActivityInstance.getWaitingActivityList().size() == 1) {
            Assert.assertEquals((Object)ActivityType.EMPTY, (Object)pickActivityInstance.getEnclosedActivity().getType());
            Assert.assertNotNull((Object)((WaitingActivity)waitingActivityIterator.next()).getExpectedStartedDate());
        }
    }

    public void checkScopeVariables(ActivityFullInstance activityFullInstance) {
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)activityFullInstance;
        if (scopeActivityFullInstance.getEnclosedActivity().getType().equals((Object)ActivityType.PICK)) {
            List variables = scopeActivityFullInstance.getVariables();
            Assert.assertEquals((int)1, (int)variables.size());
            for (VariableUpdate variableUpdate : variables) {
                Assert.assertNotNull((Object)variableUpdate.getDate());
                Assert.assertEquals((Object)scopeActivityFullInstance.getEnclosedActivityUUID(), (Object)variableUpdate.getActivityUUID());
                Assert.assertEquals((String)"st1", (String)variableUpdate.getName());
            }
        }
    }
}

