/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Set;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.activity.Process;
import org.ow2.orchestra.facade.data.def.ExitActivityDefinitionData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

public class Exit
extends AbstractBpelActivity {
    private static final long serialVersionUID = -3418645121959511051L;

    public void executeActivity(BpelExecution execution) {
        BpelExecution processInstance = execution.getProcessInstance();
        if (processInstance.getParent() != null) {
            Misc.unreachableStatement("Process instance has a parent!");
        }
        execution.waitForSignal();
        processInstance.exit();
        ProcessInstanceData pid = processInstance.getProcessInstanceData();
        Set<BpelExecution> waitingExecutions = execution.getProcessInstance().searchWaitingExecutions();
        if (waitingExecutions != null && waitingExecutions.size() > 0) {
            Misc.unreachableStatement("There are " + waitingExecutions.size() + " executions waiting after Exit!");
        }
        EnvTool.getRecorder().recordInstanceEnded(pid);
        Process.endProcessInstance(processInstance);
    }

    public ActivityType getType() {
        return ActivityType.EXIT;
    }

    public ExitActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ExitActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name);
    }
}

