/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.ow2.orchestra.cluster.ClusterDescription;
import org.ow2.orchestra.cluster.LocalServer;
import org.ow2.orchestra.cluster.Server;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.ManagementAPI;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.commands.DeployCommand;
import org.ow2.orchestra.jmx.commands.DeployWSCommand;
import org.ow2.orchestra.jmx.commands.ExitInstanceCommand;
import org.ow2.orchestra.jmx.commands.FindActivityDefinitionsCommand;
import org.ow2.orchestra.jmx.commands.FindActivityInstancesCommand;
import org.ow2.orchestra.jmx.commands.FindJobsWithExceptionCommand;
import org.ow2.orchestra.jmx.commands.FindProcessDefinitionsCommand;
import org.ow2.orchestra.jmx.commands.FindProcessInstancesCommand;
import org.ow2.orchestra.jmx.commands.GetActivityDefinitionCommand;
import org.ow2.orchestra.jmx.commands.GetActivityInstanceCommand;
import org.ow2.orchestra.jmx.commands.GetDeployedProcessDefinitionUUIDCommand;
import org.ow2.orchestra.jmx.commands.GetProcessDefinitionCommand;
import org.ow2.orchestra.jmx.commands.GetProcessInstanceCommand;
import org.ow2.orchestra.jmx.commands.InitializeCommand;
import org.ow2.orchestra.jmx.commands.RemoveInstanceCommand;
import org.ow2.orchestra.jmx.commands.RemoveProcessCommand;
import org.ow2.orchestra.jmx.commands.ResumeInstanceCommand;
import org.ow2.orchestra.jmx.commands.RetryJobCommand;
import org.ow2.orchestra.jmx.commands.SuspendInstanceCommand;
import org.ow2.orchestra.jmx.commands.UndeployCommand;
import org.ow2.orchestra.jmx.commands.UndeployWSCommand;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeployerImpl
implements RemoteDeployerMBean {
    private static Logger LOG = Logger.getLogger(RemoteDeployerImpl.class.getName());
    private final Server localServer;
    private final EnvironmentFactory environmentFactory;

    public RemoteDeployerImpl(EnvironmentFactory environmentFactory) {
        this.localServer = new LocalServer(this);
        this.environmentFactory = environmentFactory;
    }

    public RemoteDeployerImpl(Server orchestraServer, EnvironmentFactory environmentFactory) {
        this.localServer = orchestraServer;
        this.environmentFactory = environmentFactory;
    }

    protected CommandService getCommandService() {
        return this.environmentFactory.get(CommandService.class);
    }

    public <T> T execute(Command<T> command) {
        return this.getCommandService().execute(command);
    }

    @Override
    public ProcessDefinition deploy(Deployment bpelDeployment) {
        ProcessDefinition processDefinition = this.execute(new DeployCommand(bpelDeployment));
        if (processDefinition != null) {
            try {
                this.deployWebServicesOnCluster(processDefinition.getUUID(), false);
            }
            catch (RuntimeException e) {
                this.undeployWebServicesOnCluster(processDefinition.getUUID(), true);
                this.execute(new UndeployCommand(processDefinition.getUUID()));
                throw e;
            }
        }
        return processDefinition;
    }

    protected void deployWebServicesOnCluster(ProcessDefinitionUUID processDefinitionUUID, boolean ignoreExceptions) {
        Collection<Server> servers = this.getOrchestraServersInCluster();
        for (Server server : servers) {
            ManagementAPI managementAPI = null;
            if (server.equals(this.localServer)) {
                managementAPI = this;
            } else {
                try {
                    managementAPI = server.getManagementAPI();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Connection to server " + server + " failed.", e);
                }
            }
            if (managementAPI == null) continue;
            try {
                managementAPI.deployWebServices(processDefinitionUUID);
                LOG.log(Level.INFO, "Web services for process " + processDefinitionUUID + " successfully deployed on server " + server + ".");
            }
            catch (RuntimeException e) {
                if (ignoreExceptions) {
                    LOG.log(Level.WARNING, "Web services deployment for process " + processDefinitionUUID + " failed on server " + server + ".", e);
                    continue;
                }
                throw e;
            }
        }
    }

    protected void undeployWebServicesOnCluster(ProcessDefinitionUUID processDefinitionUUID, boolean ignoreExceptions) {
        Collection<Server> servers = this.getOrchestraServersInCluster();
        for (Server server : servers) {
            ManagementAPI managementAPI = null;
            try {
                managementAPI = server.getManagementAPI();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Connection to server " + server + " failed.", e);
            }
            if (managementAPI == null) continue;
            try {
                managementAPI.undeployWebServices(processDefinitionUUID);
                LOG.log(Level.INFO, "Web services for process " + processDefinitionUUID + " successfully undeployed on server " + server + ".");
            }
            catch (RuntimeException e) {
                if (ignoreExceptions) {
                    LOG.log(Level.WARNING, "Web services undeployment for process " + processDefinitionUUID + " failed on server " + server + ".", e);
                    continue;
                }
                throw e;
            }
        }
    }

    private Collection<Server> getOrchestraServersInCluster() {
        return this.execute(new Command<Collection<Server>>(){

            @Override
            public Collection<Server> execute(Environment environment) {
                ClusterDescription clusterDescription = environment.get(ClusterDescription.class);
                if (clusterDescription != null) {
                    return clusterDescription.getOrchestraServers();
                }
                return Collections.singletonList(RemoteDeployerImpl.this.localServer);
            }
        });
    }

    @Override
    public void deployWebServices(ProcessDefinitionUUID processDefinitionUUID) {
        this.execute(new DeployWSCommand(processDefinitionUUID));
    }

    @Override
    public void undeployWebServices(ProcessDefinitionUUID processDefinitionUUID) {
        this.execute(new UndeployWSCommand(processDefinitionUUID));
    }

    @Override
    public boolean undeploy(QName processQName) {
        ProcessDefinitionUUID processDefinitionUUID = this.execute(new GetDeployedProcessDefinitionUUIDCommand(processQName));
        return this.undeploy(processDefinitionUUID);
    }

    @Override
    public boolean undeploy(ProcessDefinitionUUID pduuid) {
        this.undeployWebServicesOnCluster(pduuid, false);
        try {
            return this.getCommandService().execute(new UndeployCommand(pduuid));
        }
        catch (RuntimeException e) {
            this.deployWebServicesOnCluster(pduuid, true);
            throw e;
        }
    }

    @Override
    public boolean remove(ProcessDefinitionUUID processDefinitionUUID) {
        return this.getCommandService().execute(new RemoveProcessCommand(processDefinitionUUID));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions() {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand());
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(ProcessState state) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(state));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processName, ProcessState state) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(state, processName));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processName) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(processName));
    }

    @Override
    public ProcessDefinition getProcessDefinition(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new GetProcessDefinitionCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefUUID) throws ActivityNotFoundException {
        try {
            return this.getCommandService().execute(new GetActivityDefinitionCommand(activityDefUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ActivityNotFoundException) {
                throw (ActivityNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ActivityDefinition> findActivityDefinitions(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new FindActivityDefinitionsCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ProcessDefinition deployBar(byte[] barFile) {
        try {
            ZipEntry zipFile;
            new File(System.getProperty("java.io.tmpdir")).mkdirs();
            File tmpDir = File.createTempFile("orch", null, null);
            tmpDir.delete();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Cannot create the temporary directory '" + tmpDir + "'.");
            }
            ArrayList<URL> wsdlUrls = new ArrayList<URL>();
            URL bpelFile = null;
            ByteArrayInputStream in = new ByteArrayInputStream(barFile);
            ZipInputStream zipInput = new ZipInputStream(in);
            HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
            while ((zipFile = zipInput.getNextEntry()) != null) {
                File outFile = new File(tmpDir.getAbsolutePath() + File.separator + zipFile.getName());
                if (zipFile.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                byte[] content = Misc.getAllContentFrom(zipInput);
                resources.put(zipFile.getName(), content);
                Misc.write(content, outFile);
                if (zipFile.getName().endsWith(".wsdl")) {
                    wsdlUrls.add(outFile.toURI().toURL());
                    continue;
                }
                if (!zipFile.getName().endsWith(".bpel")) continue;
                if (bpelFile != null) {
                    throw new OrchestraRuntimeException("Bar contains more than one bpel file.");
                }
                bpelFile = outFile.toURI().toURL();
            }
            zipInput.close();
            ((InputStream)in).close();
            Deployment deployment = DeploymentUtil.generateDeployment(bpelFile, wsdlUrls);
            deployment.getResourcesRepository().getResources().putAll(resources);
            ProcessDefinition process = this.deploy(deployment);
            Misc.deleteDir(tmpDir);
            return process;
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("Unable to deploy bar", e);
        }
    }

    @Override
    public void initialize() {
        this.getCommandService().execute(new InitializeCommand());
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new FindActivityInstancesCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new FindActivityInstancesCommand(processUUID, activityState));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances() {
        return this.getCommandService().execute(new FindProcessInstancesCommand());
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new FindProcessInstancesCommand(processDefinitionUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new FindProcessInstancesCommand(processDefinitionUUID, processInstanceState));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ActivityState processInstanceState) {
        return this.getCommandService().execute(new FindProcessInstancesCommand(processInstanceState));
    }

    @Override
    public ProcessInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new GetProcessInstanceCommand(processInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) throws ActivityInstanceNotFoundException {
        try {
            return this.getCommandService().execute(new GetActivityInstanceCommand(activityInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ActivityInstanceNotFoundException) {
                throw (ActivityInstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void exit(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new ExitInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public void resume(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new ResumeInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public void suspend(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new SuspendInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public boolean remove(ProcessInstanceUUID processInstanceUUID) {
        return this.getCommandService().execute(new RemoveInstanceCommand(processInstanceUUID));
    }

    @Override
    public List<JobData> findJobsWithException() {
        return this.getCommandService().execute(new FindJobsWithExceptionCommand());
    }

    @Override
    public void retryJob(JobData jobData, int retries) throws JobNotFoundException {
        if (!this.getCommandService().execute(new RetryJobCommand(retries, jobData)).booleanValue()) {
            throw new JobNotFoundException(jobData);
        }
    }
}

