/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.deployment.ProcessDeploymentCounter;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.RuntimeDbSession;
import org.ow2.orchestra.pvm.internal.hibernate.HibernatePvmDbSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeDbSessionImpl
extends HibernatePvmDbSession
implements RuntimeDbSession {
    public RuntimeDbSessionImpl(Session session) {
        this.setSession(session);
        session.setFlushMode(FlushMode.COMMIT);
    }

    @Override
    public BpelProcess findBpelProcess(String namespace, String name, int version) {
        Query query = this.getSession().getNamedQuery("findBpelProcess");
        query.setString("namespace", namespace);
        query.setString("name", name);
        query.setInteger("version", version);
        query.setCacheable(true);
        BpelProcess processDefinition = (BpelProcess)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public BpelProcess findBpelProcess(String namespace, String name) {
        Query query = this.getSession().getNamedQuery("findLatestBpelProcess");
        query.setString("namespace", namespace);
        query.setString("name", name);
        query.setCacheable(true);
        return (BpelProcess)query.uniqueResult();
    }

    @Override
    public BpelProcess findBpelProcess(ProcessDefinitionUUID pduuid, boolean lock) {
        if (lock) {
            Query query = this.getSession().getNamedQuery("findBpelProcessForLock");
            query.setString("uuid", pduuid.toString());
            query.setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE));
            query.setCacheable(false);
            BpelProcess.InstanceCreationLock res = (BpelProcess.InstanceCreationLock)query.uniqueResult();
            if (res == null) {
                return null;
            }
        }
        return this.getBpelProcess(pduuid);
    }

    @Override
    public BpelProcess getBpelProcess(ProcessDefinitionUUID pduuid) {
        Query query = this.getSession().getNamedQuery("getBpelProcessByUUID");
        query.setString("uuid", pduuid.toString());
        query.setCacheable(true);
        BpelProcess processDefinition = (BpelProcess)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public List<BpelProcess> getBpelProcesses() {
        Query query = this.getSession().getNamedQuery("getBpelProcesses");
        query.setCacheable(true);
        return query.list();
    }

    @Override
    public WaitingExecution.WaitingExecutionIterator getWaitingExecutions(InboundMessageElement inboundMessageElement) {
        Query query = this.getSession().getNamedQuery("getWaitingExecutions");
        query.setParameter("activity", (Object)inboundMessageElement);
        ScrollableResults waitingExecutions = query.scroll();
        return new WaitingExecutionIteratorImpl(waitingExecutions, this.getSession());
    }

    @Override
    public WaitingExecution getFirstWaitingExecution(InboundMessageElement inboundMessageElement) {
        Query query = this.getSession().getNamedQuery("getWaitingExecutions");
        query.setParameter("activity", (Object)inboundMessageElement);
        query.setMaxResults(1);
        Serializable id = (Serializable)query.uniqueResult();
        if (id != null) {
            return this.get(WaitingExecution.class, id);
        }
        return null;
    }

    @Override
    public Collection<PendingMessage> getPendingMessages(OperationKey operationKey) {
        Query query = this.getSession().getNamedQuery("getPendingMessages");
        query.setString("operationKey", operationKey.toString());
        return query.list();
    }

    @Override
    public List<BpelExecution> getBpelInstances() {
        Query query = this.getSession().getNamedQuery("getBpelInstances");
        return query.list();
    }

    @Override
    public BpelExecution getBpelInstance(ProcessInstanceUUID processInstanceUUID) {
        Query query = this.getSession().getNamedQuery("getBpelInstance");
        query.setString("processInstanceUUID", processInstanceUUID.toString());
        BpelExecution bpelExecution = (BpelExecution)query.uniqueResult();
        return bpelExecution;
    }

    @Override
    public List<BpelExecution> getBpelInstances(QName processQName) {
        Query query = this.getSession().getNamedQuery("getBpelInstancesOfProcess");
        query.setString("namespace", processQName.getNamespaceURI());
        query.setString("name", processQName.getLocalPart());
        return query.list();
    }

    @Override
    public ProcessDeploymentCounter getProcessDeploymentCounter() {
        return (ProcessDeploymentCounter)this.getSession().createCriteria(ProcessDeploymentCounter.class).uniqueResult();
    }

    private static class WaitingExecutionIteratorImpl
    implements WaitingExecution.WaitingExecutionIterator {
        private final ScrollableResults results;
        private final Session session;
        private WaitingExecution current = null;

        public WaitingExecutionIteratorImpl(ScrollableResults results, Session session) {
            this.results = results;
            this.session = session;
        }

        public WaitingExecution next() {
            if (this.current != null) {
                this.session.evict(this.current);
            }
            if (this.results.next()) {
                Serializable id = (Serializable)this.results.get(0);
                this.current = (WaitingExecution)this.session.get(WaitingExecution.class, id);
                if (this.current == null) {
                    Misc.log(Level.INFO, "WaitingExecution %s not found, skipping.", id);
                    return this.next();
                }
                return this.current;
            }
            return null;
        }
    }
}

