/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.logging.Logger;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.runtime.PartnerLinkUpdateType;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PartnerLinkRuntime {
    private static Logger log = Logger.getLogger(PartnerLinkRuntime.class.getName());
    protected long dbid;
    protected int dbversion;
    protected ActivityInstanceUUID scopeActivityInstanceUUID;
    protected String name;
    protected PartnerLink partnerLinkDefinition;
    private Document partnerRoleEndPointReference;
    private Document myRoleEndPointReference;

    protected PartnerLinkRuntime() {
    }

    public PartnerLinkRuntime(PartnerLink partnerLinkDefinition, BpelExecution execution, ActivityInstanceUUID scopeActivityInstanceUUID) {
        this.scopeActivityInstanceUUID = scopeActivityInstanceUUID;
        this.name = partnerLinkDefinition.getName();
        this.partnerLinkDefinition = partnerLinkDefinition;
        if (partnerLinkDefinition.getMyRolePortTypeQName() != null) {
            this.initializeMyRole(execution);
        }
        if (partnerLinkDefinition.getPartnerRolePortTypeQName() != null) {
            this.initializePartnerRole(execution);
        }
    }

    public void initializePartnerRole(BpelExecution execution) {
        if (this.partnerLinkDefinition.getDefaultPartnerRoleEndPointReference() != null) {
            EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(execution.getActivityInstanceUUID(), execution.getActivityInstanceUUID(), this.name, PartnerLinkUpdateType.PARTNER_ROLE_INITIALIZED, this.partnerLinkDefinition.getDefaultPartnerRoleEndPointReference().getDocumentElement()));
        }
    }

    public void initializeMyRole(BpelExecution execution) {
        if (this.partnerLinkDefinition.getDefaultMyRoleEndPointReference() != null) {
            EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(execution.getActivityInstanceUUID(), execution.getActivityInstanceUUID(), this.name, PartnerLinkUpdateType.MY_ROLE_INITIALIZED, this.partnerLinkDefinition.getDefaultMyRoleEndPointReference().getDocumentElement()));
        }
    }

    public Element getMyRoleEndPointReference() {
        if (this.myRoleEndPointReference != null) {
            return this.myRoleEndPointReference.getDocumentElement();
        }
        if (this.partnerLinkDefinition.getDefaultMyRoleEndPointReference() != null) {
            return this.partnerLinkDefinition.getDefaultMyRoleEndPointReference().getDocumentElement();
        }
        return null;
    }

    public void setMyRoleEndPointReference(Element myRoleEndPointReference) {
        Document doc = XmlUtil.getNewDocument();
        doc.appendChild(doc.importNode(myRoleEndPointReference, true));
        this.myRoleEndPointReference = doc;
    }

    public Element getPartnerRoleEndPointReference() {
        if (this.partnerRoleEndPointReference != null) {
            return this.partnerRoleEndPointReference.getDocumentElement();
        }
        if (this.partnerLinkDefinition.getDefaultPartnerRoleEndPointReference() != null) {
            return this.partnerLinkDefinition.getDefaultPartnerRoleEndPointReference().getDocumentElement();
        }
        return null;
    }

    public void setPartnerRoleEndPointReference(Element partnerRoleEndPointReference, ActivityInstanceUUID activityInstanceUUID) {
        Document doc = XmlUtil.getNewDocument();
        doc.appendChild(doc.importNode(partnerRoleEndPointReference, true));
        this.partnerRoleEndPointReference = doc;
        EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(this.scopeActivityInstanceUUID, activityInstanceUUID, this.name, PartnerLinkUpdateType.PARTNER_ROLE_UPDATED, this.partnerRoleEndPointReference.getDocumentElement()));
    }

    public String getName() {
        return this.name;
    }

    public PartnerLink getPartnerLinkDefinition() {
        return this.partnerLinkDefinition;
    }

    public long getDbid() {
        return this.dbid;
    }
}

