/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.data.runtime.VariableUpdateData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VariableRuntime {
    protected long dbid;
    protected int dbversion;
    private static Logger log = Logger.getLogger(VariableRuntime.class.getName());
    protected String name;
    protected Document xmlValue;
    protected Variable variableDefinition;
    protected ScopeRuntime scopeRuntime;

    protected VariableRuntime() {
    }

    public VariableRuntime(Variable variableDefinition, BpelExecution execution, ScopeRuntime scopeRuntime) {
        this.scopeRuntime = scopeRuntime;
        this.name = variableDefinition.getName();
        this.variableDefinition = variableDefinition;
        this.xmlValue = null;
    }

    public void initializeVariable(BpelExecution execution) {
        Copy initCopy = this.variableDefinition.getVirtualCopy();
        if (initCopy != null) {
            initCopy.execute(execution);
        }
        this.updated(execution.getActivityInstanceUUID());
    }

    public Variable getVariableDefinition() {
        return this.variableDefinition;
    }

    public void setVariableDefinition(Variable variableDefinition) {
        this.variableDefinition = variableDefinition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        if (this.xmlValue == null) {
            this.xmlValue = XmlUtil.getDocumentFromString(XmlUtil.toString(this.variableDefinition.getDefaultValue()));
        }
        if (this.variableDefinition.getMessageType() != null) {
            return new MessageVariable(this.xmlValue);
        }
        if (this.xmlValue == null) {
            return null;
        }
        return this.xmlValue.getDocumentElement();
    }

    public void setValue(MessageVariable message) {
        if (this.variableDefinition.getMessageType() == null) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.mismatchedAssignmentFailure, "trying to set a messageValue and the variableDefinition is not a messageType : " + this.toString(), null);
        }
        this.xmlValue = message.getPartsAsDocument();
    }

    public void setValue(Object value, boolean keepSrcElementName) {
        if (this.variableDefinition.getMessageType() != null) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.mismatchedAssignmentFailure, "trying to set a xmlValue and the variableDefinition is a messageType : " + this.toString(), null);
        }
        if (this.xmlValue == null) {
            Element defaultDocElt = this.variableDefinition.getDefaultValue().getDocumentElement();
            this.xmlValue = XmlUtil.getDocumentWithOneElement(new QName(defaultDocElt.getNamespaceURI(), defaultDocElt.getLocalName())).getOwnerDocument();
        }
        BpelXmlUtil.setObjectValue(this.xmlValue.getDocumentElement(), value, keepSrcElementName);
    }

    public void updated(ActivityInstanceUUID activityInstanceUUID) {
        if ("ORCHESTRA_4_INBOUND_WSDL_MESSAGE".equals(this.name) || "ORCHESTRA_4_OUTBOUND_WSDL_MESSAGE".equals(this.name)) {
            return;
        }
        if (this.variableDefinition.getMessageType() == null) {
            EnvTool.getRecorder().recordVariableUpdated(new VariableUpdateData(this.scopeRuntime.getActivityInstanceUUID(), activityInstanceUUID, this.name, this.xmlValue.getDocumentElement()));
        } else {
            EnvTool.getRecorder().recordVariableUpdated(new VariableUpdateData(this.scopeRuntime.getActivityInstanceUUID(), activityInstanceUUID, this.name, new MessageVariable(this.xmlValue)));
        }
    }

    public long getDbid() {
        return this.dbid;
    }
}

