/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.job;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.wsdl.Definition;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.InvokeExecutor;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.impl.PublisherImpl;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteInvokeJob
extends MessageImpl<Void> {
    public static final Date LOCK_TIMEOUT_DATE = new GregorianCalendar(4242, 0, 1).getTime();
    private final ExecuteInvokeJobData data = new ExecuteInvokeJobData();

    protected ExecuteInvokeJob() {
    }

    public ExecuteInvokeJob(MessageVariable requestMessage, Element partnerEndPointReference, OperationKey operationKey) {
        this.data.setRequestMessage(requestMessage != null ? requestMessage.duplicate() : null);
        if (partnerEndPointReference != null) {
            this.data.setPartnerEndPointReference(partnerEndPointReference.getOwnerDocument());
        }
        this.data.setOperationKey(operationKey);
    }

    @Override
    public Void execute(Environment environment) {
        this.setLockExpirationTime(LOCK_TIMEOUT_DATE);
        this.setLockOwner(null);
        BpelExecution bpelExecution = (BpelExecution)this.getExecution();
        PublisherImpl publisherImpl = environment.get(PublisherImpl.class);
        Set<Definition> wsdlDefinitions = publisherImpl != null ? publisherImpl.getWsdlDefinitions(this.data.getOperationKey().getProcessUUID()) : new HashSet<Definition>(bpelExecution.getProcessDefinition().getWsdlInfos().getWsdlDefinitions());
        environment.get(InvokeExecutor.class).executeInvoke(environment, bpelExecution, this.data.getOperationKey(), this.data.getPartnerEndPointReference().getDocumentElement(), this.data.getRequestMessage(), wsdlDefinitions);
        return null;
    }

    public static class ExecuteInvokeJobData {
        private MessageVariable requestMessage;
        private Document partnerEndPointReference;
        private OperationKey operationKey;
        private boolean isOneWay;

        public MessageVariable getRequestMessage() {
            return this.requestMessage;
        }

        public void setRequestMessage(MessageVariable requestMessage) {
            this.requestMessage = requestMessage;
        }

        public Document getPartnerEndPointReference() {
            return this.partnerEndPointReference;
        }

        public void setPartnerEndPointReference(Document partnerEndPointReference) {
            this.partnerEndPointReference = partnerEndPointReference;
        }

        public OperationKey getOperationKey() {
            return this.operationKey;
        }

        public void setOperationKey(OperationKey operationKey) {
            this.operationKey = operationKey;
        }
    }
}

