/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class While
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(While.class.getName());
    protected Expression condition;

    @Override
    public void executeActivity(BpelExecution execution) {
        NodeImpl node = execution.getNode();
        Node firstNode = node.getNodes().get(0);
        this.executeLoop((BpelExecution)execution.createExecution(), firstNode);
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            NodeImpl node = execution.getNode();
            Node firstNode = node.getNodes().get(0);
            this.executeLoop(execution, firstNode);
        } else if (signal.equals("finished")) {
            this.afterRunned(execution);
        }
    }

    private void executeLoop(BpelExecution execution, Node node) {
        boolean whileResult = this.condition.getEvaluator().evaluateBoolean(execution);
        if (whileResult) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("while condition : " + this.condition + " evaluated to true");
            }
            execution.execute(node);
        } else {
            execution.end("ended");
            BpelExecution whileExecution = execution.getParent();
            whileExecution.removeExecution(execution);
            whileExecution.signal("finished");
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.WHILE;
    }
}

