/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.IScope;
import org.ow2.orchestra.definition.activity.Receive;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.definition.element.FromPart;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.To;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.CorrelationDefinition;
import org.ow2.orchestra.facade.def.FromPartDefinition;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.OnEventFullDefinition;
import org.ow2.orchestra.facade.def.full.OnMessageFullDefinition;
import org.ow2.orchestra.facade.def.full.ReceiveActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.ReceiveActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.CorrelationDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.FromPartDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.exception.CorrelationSetNotFoundException;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(ReceiveBinding.class.getName());

    public ReceiveBinding() {
        super("receive", ActivityType.RECEIVE);
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        OperationKey operationKey;
        Element correlationsElement;
        Element fromPartsElement;
        PartnerLink partnerLink;
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        Receive receive = new Receive();
        this.setEnclosingScope(receive, parse);
        this.parseStandardAttributes(element, receive, parse);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        this.parseStandardElements(element, receive, parse);
        BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
        receive.setVariable(XmlUtil.attribute(element, "variable"));
        String partnerLinkName = XmlUtil.attribute(element, "partnerLink");
        receive.setPartnerLinkName(partnerLinkName);
        String operation = XmlUtil.attribute(element, "operation");
        receive.setCreateInstance(BpelUtil.booleanValue(XmlUtil.attribute(element, "createInstance"), false));
        String messageExchange = XmlUtil.attribute(element, "messageExchange");
        if (messageExchange != null) {
            receive.setMessageExchange(messageExchange);
        }
        if ((partnerLink = this.findPartnerLinkDefinition(parse, partnerLinkName)) == null) {
            parse.addProblem("No partnerLink " + partnerLinkName + " defined.");
            return null;
        }
        QName plportType = partnerLink.getMyRolePortTypeQName();
        if (plportType == null) {
            String message = StaticAnalysisFault.getMessage("SA00005", "  receive " + receive.getName() + " has specified a partnerLink that not corresponds to myRole");
            parse.addProblem(message, new StaticAnalysisException("SA00005"));
            return null;
        }
        receive.setOperationKey(new OperationKey(bpelProcess.getUUID(), plportType, operation));
        Operation operationWsdl = bpelProcess.getWsdlInfos().getPortType(plportType).getOperation(operation, null, null);
        if (operationWsdl != null && operationWsdl.getInput() != null) {
            receive.setInputMessageType(operationWsdl.getInput().getMessage().getQName());
        }
        ((ReceiveActivityFullDefinition)activityFullDefinition).setVariable(receive.getVariable());
        ((ReceiveActivityFullDefinition)activityFullDefinition).setPartnerLink(receive.getPartnerLinkName());
        ((ReceiveActivityFullDefinition)activityFullDefinition).setOperation(receive.getOperation());
        ((ReceiveActivityFullDefinition)activityFullDefinition).setCreateInstance(receive.isCreateInstance());
        ((ReceiveActivityFullDefinition)activityFullDefinition).setMessageExchange(receive.getMessageExchange());
        ((ReceiveActivityFullDefinition)activityFullDefinition).setPortType(receive.getPortTypeQName());
        if (XmlUtil.attribute(element, "portType") != null && !plportType.equals(XmlUtil.attributeQName(element, "portType"))) {
            String message = StaticAnalysisFault.getMessage("SA00005", "  receive " + receive.getName() + " has specified a PortType that is different from the one specified by the partnerLink");
            parse.addProblem(message, new StaticAnalysisException("SA00005"));
        }
        if ((fromPartsElement = XmlUtil.element(element, "fromParts")) != null) {
            if (receive.getVariable() != null) {
                String message = StaticAnalysisFault.getMessage("SA00055", "  receive " + receive.getName() + " has specified both a Variable and a fromPart");
                parse.addProblem(message, new StaticAnalysisException("SA00055"));
                return null;
            }
            List<Element> fromPartElements = XmlUtil.elements(fromPartsElement, "fromPart");
            receive.setAnonymousInboundMessageVariable(ReceiveBinding.getAnonymousVariable(receive, parse));
            List<Copy> inCopies = ReceiveBinding.getInCopies(fromPartElements, receive.getEnclosingScope(), parse, null);
            if (inCopies.size() != 0) {
                receive.setInCopies(inCopies);
            }
        }
        if ((correlationsElement = XmlUtil.element(element, "correlations")) != null) {
            List<Element> correlationElements = XmlUtil.elements(correlationsElement, "correlation");
            try {
                receive.setCorrelations(ReceiveBinding.parseCorrelations(correlationElements, (Scope)receive.getEnclosingScope(), parse, null));
            }
            catch (CorrelationSetNotFoundException e) {
                parse.addProblem("A correlation has not been defined in enclosing scopes", e);
            }
        }
        NodeImpl receiveNode = this.createActivityNode(element, parse, parser, (ExternalActivity)receive);
        if (BpelUtil.isCreateInstance(element) && bpelProcess.addStartElement(operationKey = receive.getOperationKey(), receive) != null) {
            parse.addProblem("More than one start activity found for operationKey: " + operationKey + ". This is not allowed.", new StaticAnalysisException("SA10001"));
        }
        bpelProcess.addInboundMessageElement(receive);
        return receiveNode;
    }

    protected static List<Correlation> parseCorrelations(List<Element> correlationElements, Scope enclosingScope, Parse parse, Object onMessageFullDefinition) throws CorrelationSetNotFoundException {
        ArrayList<Correlation> correlations = new ArrayList<Correlation>();
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        ArrayList<CorrelationDefinition> correlationDefinitionList = new ArrayList<CorrelationDefinition>();
        if (correlationElements != null) {
            for (Element correlationElement : correlationElements) {
                Correlation correlation = new Correlation();
                String set = XmlUtil.attribute(correlationElement, "set");
                correlation.setCorrelationSet(enclosingScope.findCorrelationSet(set));
                String initiate = XmlUtil.attribute(correlationElement, "initiate");
                correlation.setInitiate(initiate);
                correlations.add(correlation);
                CorrelationDefinitionImpl correlationDefinition = new CorrelationDefinitionImpl(set, initiate);
                correlationDefinitionList.add(correlationDefinition);
            }
            if (ActivityType.RECEIVE.equals((Object)activityFullDefinition.getType())) {
                ((ReceiveActivityFullDefinition)activityFullDefinition).setCorrelationDefinition(correlationDefinitionList);
            } else if (onMessageFullDefinition instanceof OnMessageFullDefinition) {
                ((OnMessageFullDefinition)onMessageFullDefinition).setCorrelationDefinition(correlationDefinitionList);
            } else if (onMessageFullDefinition instanceof OnEventFullDefinition) {
                ((OnEventFullDefinition)onMessageFullDefinition).setCorrelationDefinition(correlationDefinitionList);
            }
        }
        return correlations;
    }

    protected static Variable getAnonymousVariable(ReceivingElement receivingElement, Parse parse) {
        BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
        Operation operation = bpelProcess.getWsdlInfos().getPortType(receivingElement.getPortTypeQName()).getOperation(receivingElement.getOperation(), null, null);
        QName messageQName = operation.getInput().getMessage().getQName();
        Variable anonymousInboundMessageVariable = new Variable();
        anonymousInboundMessageVariable.setName("ORCHESTRA_4_INBOUND_WSDL_MESSAGE");
        anonymousInboundMessageVariable.setMessageType(messageQName);
        anonymousInboundMessageVariable.initDefaultValue(bpelProcess.getWsdlInfos());
        return anonymousInboundMessageVariable;
    }

    protected static List<Copy> getInCopies(List<Element> fromPartElements, IScope enclosingScope, Parse parse, Object onMessageFullDefinition) {
        ArrayList<Copy> inCopies = new ArrayList<Copy>();
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        ArrayList<FromPartDefinition> fromPartDefinitionList = new ArrayList<FromPartDefinition>();
        if (fromPartElements != null) {
            ArrayList<FromPart> fromParts = new ArrayList<FromPart>();
            for (Element fromPartElement : fromPartElements) {
                FromPart fromPart = new FromPart();
                String part = XmlUtil.attribute(fromPartElement, "part");
                fromPart.setPart(part);
                String toVariable = XmlUtil.attribute(fromPartElement, "toVariable");
                fromPart.setToVariable(toVariable);
                fromParts.add(fromPart);
                FromPartDefinitionImpl fromPartDefinition = new FromPartDefinitionImpl(fromPart.getPart(), fromPart.getToVariable());
                fromPartDefinitionList.add(fromPartDefinition);
            }
            if (ActivityType.RECEIVE.equals((Object)activityFullDefinition.getType())) {
                ((ReceiveActivityFullDefinition)activityFullDefinition).setFromPartDefinition(fromPartDefinitionList);
            } else if (onMessageFullDefinition instanceof OnMessageFullDefinition) {
                ((OnMessageFullDefinition)onMessageFullDefinition).setFromPartDefinition(fromPartDefinitionList);
            } else if (onMessageFullDefinition instanceof OnEventFullDefinition) {
                ((OnEventFullDefinition)onMessageFullDefinition).setFromPartDefinition(fromPartDefinitionList);
            }
            for (FromPart fromPart : fromParts) {
                From from = new From();
                from.setVariable("ORCHESTRA_4_INBOUND_WSDL_MESSAGE");
                from.setPart(fromPart.getPart());
                from.setVariant(Variant.VAR);
                To to = new To();
                to.setVariable(fromPart.getToVariable());
                to.setVariant(Variant.VAR);
                Copy copy = new Copy();
                copy.setKeepSrcElementName(true);
                copy.setFrom(from);
                copy.setTo(to);
                inCopies.add(copy);
            }
        }
        return inCopies;
    }

    @Override
    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new ReceiveActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

