/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.deploy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.deploy.Deployer;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerManager {
    private static final Log LOG = Log.getLog(DeployerManager.class.getName());
    protected Map<String, String> extensions = new HashMap<String, String>();
    protected Map<String, List<Deployer>> deployers = new HashMap<String, List<Deployer>>();

    public void deploy(Deployment deployment) {
        if (deployment == null) {
            throw new PvmException("deployment is null");
        }
        String language = deployment.getLanguage();
        if (language == null) {
            String deploymentName = deployment.getName();
            LOG.trace("no language specified in deployment, looking for extension in " + deploymentName);
            if (deploymentName == null) {
                throw new PvmException("no name nor language specified in deployment");
            }
            Iterator<Map.Entry<String, String>> iter = this.extensions.entrySet().iterator();
            while (iter.hasNext() && language == null) {
                Map.Entry<String, String> extensionEntry = iter.next();
                if (!deploymentName.endsWith(extensionEntry.getKey())) continue;
                language = extensionEntry.getValue();
            }
            if (language == null) {
                throw new PvmException("couldn't find process language matching extension of " + deploymentName + " for deploying " + deployment);
            }
        }
        LOG.trace("looking up process deployer sequence for language " + language);
        List<Deployer> deployerSequence = this.deployers.get(language);
        if (deployerSequence == null) {
            throw new PvmException("couldn't find deployer sequence for language " + language + " for deploying " + deployment);
        }
        LOG.debug("deploying deployment " + deployment + " with " + language + "-parser");
        for (Deployer deployer : deployerSequence) {
            LOG.trace("deploying " + deployment + " to " + deployer);
            deployer.deploy(deployment);
        }
    }

    public static String getExtension(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            throw new PvmException("can't extract extension of deployment: no file name");
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            lastDotIndex = 0;
        }
        return fileName.substring(lastDotIndex);
    }

    public void addLanguage(String language, String extension, List<Deployer> deployerSequence) {
        if (extension != null) {
            this.extensions.put(extension, language);
        }
        this.deployers.put(language, deployerSequence);
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    public void setDeployers(Map<String, List<Deployer>> deployers) {
        this.deployers = deployers;
    }
}

