/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.model.op;

import java.util.Map;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.op.AtomicOperation;
import org.ow2.orchestra.pvm.internal.model.op.SignalMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signal
implements AtomicOperation {
    private static final Log LOG = Log.getLog(Signal.class.getName());
    private final String signalName;
    private final Map<String, Object> parameters;
    private final NodeImpl node;

    public Signal(String signalName, Map<String, Object> parameters, NodeImpl node) {
        this.signalName = signalName;
        this.parameters = parameters;
        this.node = node;
    }

    @Override
    public boolean isAsync(ExecutionImpl execution) {
        return execution.getNode().isSignalAsync();
    }

    @Override
    public void perform(ExecutionImpl execution) {
        if (execution.getName() != null) {
            LOG.debug(execution.toString() + " signals " + this.node);
        } else {
            LOG.debug("signalling " + this.node + ", signal=" + this.signalName);
        }
        ExternalActivity externalActivity = (ExternalActivity)this.node.getBehaviour();
        try {
            execution.setPropagation(ExecutionImpl.Propagation.UNSPECIFIED);
            externalActivity.signal(execution, this.signalName, this.parameters);
        }
        catch (Exception e) {
            execution.handleException(this.node, null, null, e, execution.toString() + " couldn't signal node " + this.node);
        }
        if (execution.getPropagation() == ExecutionImpl.Propagation.UNSPECIFIED) {
            execution.proceed();
        }
    }

    public String toString() {
        return "signal(node)";
    }

    @Override
    public MessageImpl<?> createAsyncMessage(ExecutionImpl execution) {
        return new SignalMessage(execution, this.signalName, this.node);
    }
}

