/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.script;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.env.ExecutionContext;
import org.ow2.orchestra.pvm.internal.env.ExecutionEnvironment;
import org.ow2.orchestra.pvm.internal.script.EnvironmentBindings;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;
import org.ow2.orchestra.pvm.internal.wire.xml.WireParser;

public class ScriptManager {
    private static final ScriptManager DEFAULT_SCRIPT_MANAGER = ScriptManager.createDefault();
    protected String defaultExpressionLanguage;
    protected String defaultScriptLanguage;
    protected ScriptEngineManager scriptEngineManager;
    protected String[] readContextNames = null;
    protected String writeContextName;

    public static ScriptManager getScriptManager() {
        ScriptManager scriptManager;
        Environment environment = Environment.getCurrent();
        if (environment != null && (scriptManager = environment.get(ScriptManager.class)) != null) {
            return scriptManager;
        }
        return DEFAULT_SCRIPT_MANAGER;
    }

    public static ScriptManager createDefault() {
        WireDefinition wireDefinition = (WireDefinition)new WireParser().createParse().setString("<objects>  <script-manager default-expression-language='juel'                  default-script-language='beanshell'                   read-contexts='execution, environment, environment-factory'                   write-context='execution'>    <script-language name='juel' factory='com.sun.script.juel.JuelScriptEngineFactory' />  </script-manager></objects>").execute().getDocumentObject();
        WireContext wireContext = new WireContext(wireDefinition);
        return wireContext.get(ScriptManager.class);
    }

    public Object evaluateExpression(String expression, Execution execution, String language) {
        return this.evaluate(expression, execution, language != null ? language : this.defaultExpressionLanguage);
    }

    public Object evaluateScript(String script, Execution execution, String language) {
        return this.evaluate(script, execution, language != null ? language : this.defaultScriptLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(String script, Execution execution, String language) {
        if (script == null) {
            return null;
        }
        if (language == null) {
            throw new PvmException("no language specified");
        }
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(language);
        if (scriptEngine == null) {
            throw new PvmException("no scripting engine configured for language " + language);
        }
        if (execution == null) {
            return this.evaluate(scriptEngine, script);
        }
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            environment = new ExecutionEnvironment(execution);
            try {
                Object object = this.evaluate(scriptEngine, script);
                return object;
            }
            finally {
                environment.close();
            }
        }
        ExecutionContext executionContext = new ExecutionContext(execution);
        environment.addContext(executionContext);
        try {
            Object object = this.evaluate(scriptEngine, script);
            return object;
        }
        finally {
            environment.removeContext(executionContext);
        }
    }

    protected Object evaluate(ScriptEngine scriptEngine, String script) {
        EnvironmentBindings bindings = new EnvironmentBindings(this.readContextNames, this.writeContextName);
        scriptEngine.setBindings(bindings, 100);
        try {
            return scriptEngine.eval(script);
        }
        catch (ScriptException e) {
            throw new PvmException("script evaluation error: " + e.getMessage(), e);
        }
    }
}

