/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.operation;

import java.lang.reflect.Method;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.operation.AbstractOperation;

public class PropertyOperation
extends AbstractOperation {
    private static final long serialVersionUID = 1L;
    private String setterName = null;
    private Descriptor descriptor = null;

    public void apply(Object target, WireContext wireContext) {
        Object value = wireContext.create(this.descriptor, true);
        Method method = null;
        Class<?> clazz = target.getClass();
        Object[] args = new Object[]{value};
        method = ReflectUtil.findMethod(clazz, this.setterName, null, args);
        if (method == null) {
            throw new WireException("couldn't find property setter " + this.setterName + " for value " + value);
        }
        ReflectUtil.invoke(method, target, args);
    }

    public void setPropertyName(String propertyName) {
        this.setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public String getSetterName() {
        return this.setterName;
    }

    public void setSetterName(String setterName) {
        this.setterName = setterName;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor valueDescriptor) {
        this.descriptor = valueDescriptor;
    }
}

