/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.EhCache;
import net.sf.ehcache.hibernate.HibernateUtil;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.Timestamper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractEhcacheProvider
implements CacheProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractEhcacheProvider.class.getName());
    protected volatile CacheManager manager;

    AbstractEhcacheProvider() {
    }

    public final Cache buildCache(String name, Properties properties) throws org.hibernate.cache.CacheException {
        try {
            Ehcache cache = this.manager.getEhcache(name);
            if (cache == null) {
                LOG.warn("Could not find a specific ehcache configuration for cache named [" + name + "]; using defaults.");
                this.manager.addCache(name);
                cache = this.manager.getEhcache(name);
                LOG.debug("started EHCache region: " + name);
            }
            HibernateUtil.validateEhcache(cache);
            return new EhCache(cache);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException(e);
        }
    }

    public final long nextTimestamp() {
        return Timestamper.next();
    }

    public final boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    protected URL loadResource(String configurationResourceName) {
        ClassLoader standardClassloader = ClassLoaderUtil.getStandardClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(configurationResourceName);
        }
        if (url == null) {
            url = this.getClass().getResource(configurationResourceName);
        }
        LOG.debug("Creating EhCacheProvider from a specified resource: {}. Resolved to URL: ", (Object)configurationResourceName, (Object)url);
        if (url == null) {
            LOG.warn("A configurationResourceName was set to {} but the resource could not be loaded from the classpath.Ehcache will configure itself using defaults.", (Object)configurationResourceName);
        }
        return url;
    }
}

