/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.ListIterator;
import java.util.Map;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.facade.data.def.CompensateActivityDefinitionData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compensate
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1587165958245350103L;
    public static final String EXCEPTION_PARAMETER = "exception";

    @Override
    public void executeActivity(BpelExecution execution) {
        BpelExecution scopeExecution = this.findCompensateParentScopeExecution(execution);
        ScopeRuntime sr = scopeExecution.getScopeRuntime();
        if (!sr.getEndedChildren().isEmpty()) {
            ListIterator<ScopeRuntime> srIterator = sr.getEndedChildren().listIterator(sr.getEndedChildren().size());
            while (srIterator.hasPrevious()) {
                ScopeRuntime enclosedScopeRuntime = srIterator.previous();
                if (!enclosedScopeRuntime.getState().equals((Object)ScopeState.COMPLETED_SUCCESSFUL)) continue;
                BpelExecution childExecution = (BpelExecution)scopeExecution.createExecution();
                childExecution.pushScopeRuntime(enclosedScopeRuntime);
                childExecution.setActivityInstanceUUID(enclosedScopeRuntime.getActivityInstanceUUID());
                enclosedScopeRuntime.setCompensateExecution(execution);
                Node enclosedScopeNode = enclosedScopeRuntime.getScopeDefinition().getScopeNode();
                Node chNode = enclosedScopeNode.getNodes().get(3);
                childExecution.createExecution().execute(chNode);
                execution.waitForSignal();
                return;
            }
        }
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        BpelFaultException exception;
        if (parameters != null && (exception = (BpelFaultException)parameters.get(EXCEPTION_PARAMETER)) != null) {
            throw exception;
        }
        this.executeActivity(execution);
    }

    private BpelExecution findCompensateParentScopeExecution(BpelExecution execution) {
        if (execution == null) {
            Misc.unreachableStatement("No scope is currently handling fault, terminating or compensating");
            return null;
        }
        ScopeRuntime sr = execution.getScopeRuntime();
        if (sr != null && (sr.getState().equals((Object)ScopeState.HANDLING_FAULT) || sr.getState().equals((Object)ScopeState.COMPENSATING) || sr.getState().equals((Object)ScopeState.TERMINATING))) {
            return execution;
        }
        return this.findCompensateParentScopeExecution(execution.getParent());
    }

    @Override
    public ActivityType getType() {
        return ActivityType.COMPENSATE;
    }

    @Override
    public CompensateActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new CompensateActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name);
    }
}

