/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.full.impl;

import java.util.Date;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.impl.RuntimeRecordFullImpl;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.util.Misc;

public abstract class ActivityFullInstanceImpl
extends RuntimeRecordFullImpl
implements ActivityFullInstance {
    private static final long serialVersionUID = 8901738568448948365L;
    protected long dbid;
    protected long dbversion;
    protected ActivityInstanceUUID uuid;
    protected ActivityDefinitionUUID definitionUUID;
    protected BpelFaultException lastException;

    protected ActivityFullInstanceImpl() {
    }

    public ActivityFullInstanceImpl(ActivityInstanceUUID uuid, ActivityDefinitionUUID definitionUUID, ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, Date date) {
        super(processUUID, instanceUUID, date);
        Misc.checkArgsNotNull(uuid, definitionUUID);
        this.uuid = uuid;
        this.definitionUUID = definitionUUID;
    }

    public ActivityFullInstanceImpl(ActivityFullInstance activityFullInstance) {
        super(activityFullInstance);
        this.uuid = activityFullInstance.getUUID();
        this.definitionUUID = activityFullInstance.getDefinitionUUID();
        this.lastException = activityFullInstance.getLastException() != null ? activityFullInstance.getLastException().fullCopy() : null;
    }

    public final int hashCode() {
        return this.getUUID().hashCode() + super.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.uuid.equals(((ActivityFullInstanceImpl)obj).getUUID());
    }

    public ActivityInstanceUUID getUUID() {
        return this.uuid;
    }

    public ActivityDefinitionUUID getDefinitionUUID() {
        return this.definitionUUID;
    }

    public BpelFaultException getLastException() {
        return this.lastException;
    }

    public void setLastException(BpelFaultException lastException) {
        this.lastException = lastException;
    }

    public abstract ActivityType getType();

    public boolean isSingleChildActivity() {
        return false;
    }

    public boolean isChildrenActivity() {
        return false;
    }
}

