/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoveInstanceCommand
implements Command<Boolean> {
    private static final long serialVersionUID = -1899752661336351875L;
    private final ProcessInstanceUUID processInstanceUUID;

    public RemoveInstanceCommand(ProcessInstanceUUID processInstanceUUID) {
        this.processInstanceUUID = processInstanceUUID;
    }

    @Override
    public Boolean execute(Environment environment) {
        if (this.processInstanceUUID == null) {
            throw new IllegalArgumentException("Process instance uuid is null");
        }
        if (EnvTool.getRepository().getInstance(this.processInstanceUUID) != null) {
            throw new OrchestraRuntimeException("Instance " + this.processInstanceUUID + " is still running.");
        }
        Querier querier = EnvTool.getQuerier();
        return querier.removeProcessInstance(this.processInstanceUUID) != null;
    }
}

